/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import haplotype.SampleHapPairs;
import vcf.AL;
import vcf.Marker;
import vcf.Markers;

public final class HapAL
implements AL {
    private final Markers markers;
    private final SampleHapPairs partialHapPairs;
    private final int[] markers2HapMarkers;
    private final float errProb;
    private final float noErrProb;

    public HapAL(Markers markers, SampleHapPairs sampleHapPairs, float f) {
        if (Float.isNaN(f) || (double)f < 0.0 || (double)f > 1.0) {
            throw new IllegalArgumentException("err: " + f);
        }
        this.markers2HapMarkers = HapAL.markers2HapMarkers(markers, sampleHapPairs);
        this.markers = markers;
        this.partialHapPairs = sampleHapPairs;
        this.errProb = f;
        this.noErrProb = 1.0f - f;
    }

    private static int[] markers2HapMarkers(Markers markers, SampleHapPairs sampleHapPairs) {
        int[] nArray = new int[markers.nMarkers()];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            Marker marker = markers.marker(i);
            nArray[i] = n < sampleHapPairs.nMarkers() && marker.equals(sampleHapPairs.marker(n)) ? n++ : -1;
        }
        if (n != sampleHapPairs.nMarkers()) {
            String string = "partialHapPairs.markers() is not a sublist of markers";
            throw new IllegalArgumentException(string);
        }
        return nArray;
    }

    @Override
    public float al(int n, int n2, byte by) {
        if (by < 0 || by >= this.markers.marker(n).nAlleles()) {
            String string = "marker=" + n + " allele: " + by;
            throw new IllegalArgumentException(string);
        }
        int n3 = this.markers2HapMarkers[n];
        if (n3 == -1) {
            return 1.0f;
        }
        byte by2 = this.partialHapPairs.allele(n3, n2);
        return by2 == by ? this.noErrProb : this.errProb;
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public int nSamples() {
        return this.partialHapPairs.nSamples();
    }

    @Override
    public Samples samples() {
        return this.partialHapPairs.samples();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[HapAL: nMarkers=");
        stringBuilder.append(this.nMarkers());
        stringBuilder.append(" nSamples=");
        stringBuilder.append(this.nSamples());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

