/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import blbutil.SampleFileIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import main.Logger;
import vcf.Marker;
import vcf.Markers;
import vcf.VcfEmission;

public class VcfWindow {
    private final SampleFileIterator<VcfEmission> it;
    private int overlap;
    private int cumMarkerCnt;
    private VcfEmission[] data;
    private VcfEmission next;

    public VcfWindow(SampleFileIterator<VcfEmission> sampleFileIterator) {
        if (!sampleFileIterator.hasNext()) {
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("No VCF records found.");
            if (sampleFileIterator.file() != null) {
                stringBuilder.append(" (file: ");
                stringBuilder.append(sampleFileIterator.file());
                stringBuilder.append(")");
            }
            stringBuilder.append(Const.nl);
            stringBuilder.append("Check that the chromosome identifiers are the same in each input VCF");
            stringBuilder.append(Const.nl);
            stringBuilder.append("file and in the 'chrom=' command line argument (if 'chrom=' is used).");
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.overlap = 0;
        this.cumMarkerCnt = 0;
        this.it = sampleFileIterator;
        this.data = new VcfEmission[0];
        this.next = (VcfEmission)sampleFileIterator.next();
    }

    public boolean lastWindowOnChrom() {
        return this.next == null || this.data.length == 0 || !this.sameChrom(this.next, this.data[this.data.length - 1]);
    }

    public boolean canAdvanceWindow() {
        return this.next != null;
    }

    public VcfEmission[] advanceWindow(int n, int n2) {
        int n3;
        this.checkParameters(n, n2);
        if (!this.canAdvanceWindow()) {
            throw new IllegalStateException("canAdvanceWindow()==false");
        }
        if (n > this.data.length) {
            n = this.data.length;
        }
        if (this.data.length == 0 || !this.sameChrom(this.next, this.data[this.data.length - 1])) {
            n = 0;
        }
        assert (this.next != null);
        VcfEmission vcfEmission = this.next;
        ArrayList<VcfEmission> arrayList = new ArrayList<VcfEmission>(n2);
        for (n3 = this.data.length - n; n3 < this.data.length; ++n3) {
            arrayList.add(this.data[n3]);
        }
        for (n3 = n; n3 < n2 && this.next != null && this.sameChrom(this.next, vcfEmission); ++n3) {
            arrayList.add(this.next);
            this.next = this.readRecord(this.it);
        }
        VcfEmission vcfEmission2 = (VcfEmission)arrayList.get(arrayList.size() - 1);
        while (this.next != null && this.sameChromAndPosition(vcfEmission2, this.next)) {
            arrayList.add(this.next);
            this.next = this.readRecord(this.it);
        }
        this.overlap = n;
        this.data = arrayList.toArray(new VcfEmission[0]);
        this.cumMarkerCnt += this.data.length - n;
        return (VcfEmission[])this.data.clone();
    }

    private void checkParameters(int n, int n2) {
        if (n < 0 || n >= n2) {
            String string = "overlap=" + n + "windowSize=" + n2;
            throw new IllegalArgumentException(string);
        }
    }

    public VcfEmission[] advanceWindow(Markers markers) {
        if (!this.canAdvanceWindow()) {
            throw new IllegalStateException("canAdvanceWindow()==false");
        }
        this.checkMarkers(markers);
        VcfEmission[] vcfEmissionArray = this.data;
        VcfEmission[] vcfEmissionArray2 = new VcfEmission[markers.nMarkers()];
        int n = VcfWindow.firstNewMarkerIndex(markers, vcfEmissionArray);
        this.overlap = VcfWindow.copyOverlap(markers, n, vcfEmissionArray, vcfEmissionArray2);
        boolean bl = this.readDataForNewmarkers(markers, vcfEmissionArray2, n);
        if (this.overlap == 0 && !bl) {
            String string = VcfWindow.missingTargetMarkersErr(markers);
            throw new IllegalArgumentException(string);
        }
        this.data = vcfEmissionArray2;
        return (VcfEmission[])vcfEmissionArray2.clone();
    }

    private void checkMarkers(Markers markers) {
        if (markers.nMarkers() == 0) {
            throw new IllegalArgumentException("markers.nMarkers()=0");
        }
        Marker marker = markers.marker(0);
        Marker marker2 = markers.marker(markers.nMarkers() - 1);
        if (marker.chromIndex() != marker2.chromIndex()) {
            String string = "inconsistent chromosomes:" + Const.nl + marker + Const.nl + marker2;
            throw new IllegalArgumentException(string);
        }
    }

    private static int firstNewMarkerIndex(Markers markers, VcfEmission[] vcfEmissionArray) {
        assert (markers.nMarkers() > 0);
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = VcfWindow.lastNonNullIndex(vcfEmissionArray);
        if (n3 >= 0) {
            n = vcfEmissionArray[n3].marker().chromIndex();
            n2 = vcfEmissionArray[n3].marker().pos();
        }
        if (markers.marker(0).chromIndex() != n) {
            return 0;
        }
        int n4 = markers.nMarkers();
        int n5 = 0;
        Marker marker = markers.marker(n5);
        while (marker != null && marker.chromIndex() == n && marker.pos() <= n2) {
            marker = ++n5 < n4 ? markers.marker(n5) : null;
        }
        if (n5 == markers.nMarkers()) {
            String string = "markers do not advance current marker window";
            throw new IllegalArgumentException(string);
        }
        return n5;
    }

    private static int lastNonNullIndex(VcfEmission[] vcfEmissionArray) {
        int n;
        for (n = vcfEmissionArray.length - 1; n >= 0 && vcfEmissionArray[n] == null; --n) {
        }
        return n;
    }

    private static String missingTargetMarkersErr(Markers markers) {
        return "no target markers found in interval: " + VcfWindow.interval(markers) + Const.nl + "Check that target VCF file markers have identical CHROM, POS, REF," + Const.nl + "and ALT fields as the corresponding reference VCF file markers.";
    }

    private static String interval(Markers markers) {
        Marker marker = markers.marker(0);
        Marker marker2 = markers.marker(markers.nMarkers() - 1);
        String string = marker.chrom() + ':' + marker.pos();
        String string2 = String.valueOf(marker2.pos());
        if (marker.chromIndex() != marker2.chromIndex()) {
            string2 = marker2.chromIndex() + 58 + string2;
        }
        return string + '-' + string2;
    }

    private static int copyOverlap(Markers markers, int n, VcfEmission[] vcfEmissionArray, VcfEmission[] vcfEmissionArray2) {
        int n2 = 0;
        HashMap<Marker, VcfEmission> hashMap = new HashMap<Marker, VcfEmission>();
        for (VcfEmission vcfEmission : vcfEmissionArray) {
            if (vcfEmission == null) continue;
            hashMap.put(vcfEmission.marker(), vcfEmission);
        }
        for (int i = 0; i < n; ++i) {
            vcfEmissionArray2[i] = (VcfEmission)hashMap.get(markers.marker(i));
            if (vcfEmissionArray2[i] == null) continue;
            ++n2;
        }
        return n2;
    }

    private boolean readDataForNewmarkers(Markers markers, VcfEmission[] vcfEmissionArray, int n) {
        int n2;
        int n3 = 0;
        if (n == 0 && markers.nMarkers() > 0) {
            n2 = markers.marker(0).chromIndex();
            while (this.next != null && this.next.marker().chromIndex() != n2) {
                this.next = this.readRecord(this.it);
            }
        }
        for (n2 = n; n2 < vcfEmissionArray.length; ++n2) {
            boolean bl = this.readDataForMarker(markers, n2);
            if (!bl) continue;
            assert (this.next.marker().equals(markers.marker(n2)));
            ++n3;
            vcfEmissionArray[n2] = this.next;
            this.next = this.readRecord(this.it);
        }
        this.cumMarkerCnt += n3;
        return n3 > 0;
    }

    private boolean readDataForMarker(Markers markers, int n) {
        Marker marker = markers.marker(n);
        while (this.next != null && this.next.marker().chromIndex() == marker.chromIndex() && this.next.marker().pos() < marker.pos()) {
            this.next = this.readRecord(this.it);
        }
        while (this.next != null && this.next.marker().chromIndex() == marker.chromIndex() && this.next.marker().pos() == marker.pos() && !markers.contains(this.next.marker())) {
            this.next = this.readRecord(this.it);
        }
        return this.next != null && marker.equals(this.next.marker());
    }

    private boolean sameChrom(VcfEmission vcfEmission, VcfEmission vcfEmission2) {
        return vcfEmission.marker().chromIndex() == vcfEmission2.marker().chromIndex();
    }

    private boolean sameChromAndPosition(VcfEmission vcfEmission, VcfEmission vcfEmission2) {
        return vcfEmission.marker().chromIndex() == vcfEmission2.marker().chromIndex() && vcfEmission.marker().pos() == vcfEmission2.marker().pos();
    }

    private VcfEmission readRecord(SampleFileIterator<VcfEmission> sampleFileIterator) {
        VcfEmission vcfEmission;
        VcfEmission vcfEmission2 = vcfEmission = sampleFileIterator.hasNext() ? (VcfEmission)sampleFileIterator.next() : null;
        if (vcfEmission != null && vcfEmission.isMissingData()) {
            String string = "Skipping VCF record with no data: " + vcfEmission.marker();
            Logger.getInstance().println(string);
            vcfEmission = sampleFileIterator.hasNext() ? (VcfEmission)sampleFileIterator.next() : null;
        }
        return vcfEmission;
    }

    public File file() {
        return this.it.file();
    }

    public Samples samples() {
        return this.it.samples();
    }

    public int nSamples() {
        return this.it.samples().nSamples();
    }

    public int overlap() {
        return this.overlap;
    }

    public int cumMarkerCnt() {
        return this.cumMarkerCnt;
    }

    public void close() {
        this.it.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("vcf.VcfWindow");
        return stringBuilder.toString();
    }
}

