% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/diversity_test.R
\docType{methods}
\name{test}
\alias{test}
\alias{test_shannon}
\alias{test_shannon-method}
\alias{test_simpson}
\alias{test_simpson-method}
\alias{test_shannon,numeric,numeric-method}
\alias{test_shannon,matrix,missing-method}
\alias{test_shannon,data.frame,missing-method}
\alias{test_simpson,numeric,numeric-method}
\alias{test_simpson,matrix,missing-method}
\alias{test_simpson,data.frame,missing-method}
\title{Diversity Test}
\usage{
test_shannon(x, y, ...)

test_simpson(x, y, ...)

\S4method{test_shannon}{numeric,numeric}(x, y, ...)

\S4method{test_shannon}{matrix,missing}(x, adjust = "holm", ...)

\S4method{test_shannon}{data.frame,missing}(x, adjust = "holm", ...)

\S4method{test_simpson}{numeric,numeric}(x, y, adjust = "holm", ...)

\S4method{test_simpson}{matrix,missing}(x, adjust = "holm", ...)

\S4method{test_simpson}{data.frame,missing}(x, adjust = "holm", ...)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector, a \eqn{m \times p}{m x p} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table). A \code{\link{data.frame}}
will be coerced to a \code{numeric} \code{matrix} via \code{\link[=data.matrix]{data.matrix()}}.}

\item{...}{Further arguments to be passed to internal methods.}

\item{adjust}{A \code{\link{character}} string specifying the method for
adjusting \eqn{p} values (see \code{\link[stats:p.adjust]{stats::p.adjust()}}).}
}
\value{
If \code{x} and \code{y} are \code{numeric} vectors, returns a \code{\link{list}} containing the
following components:
\describe{
\item{\code{statistic}}{The value of the t-statistic.}
\item{\code{parameter}}{The degrees of freedom for the t-statistic.}
\item{\code{p.value}}{The p-value for the test.}
}

If \code{x} is a \code{matrix} or a \code{data.frame}, returns a table of adjusted p-values
in lower triangular form.
}
\description{
Compares Shannon/Simpson diversity between samples.
}
\section{Functions}{
\itemize{
\item \code{test_shannon(x = matrix, y = missing)}: Produces two sided pairwise comparisons.

\item \code{test_shannon(x = data.frame, y = missing)}: Produces two sided pairwise comparisons.

\item \code{test_simpson(x = matrix, y = missing)}: Produces two sided pairwise comparisons.

\item \code{test_simpson(x = data.frame, y = missing)}: Produces two sided pairwise comparisons.

}}
\examples{
## Data from Magurran 1988, p. 145-149
oakwood <- c(35, 26, 25, 21, 16, 11, 6, 5, 3, 3,
             3, 3, 3, 2, 2, 2, 1, 1, 1, 1, 0, 0)
spruce <- c(30, 30, 3, 65, 20, 11, 0, 4, 2, 14,
            0, 3, 9, 0, 0, 5, 0, 0, 0, 0, 1, 1)

test_shannon(oakwood, spruce)
test_simpson(oakwood, spruce)

## Data from Conkey 1980, Kintigh 1989
data("cantabria")

test_shannon(cantabria)
test_simpson(cantabria)
}
\references{
Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
Princeton, NJ: Princeton University Press. \doi{10.1007/978-94-015-7358-0}.
}
\author{
N. Frerebeau
}
\concept{statistics}
