% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pie_discover.R
\name{pie_discover}
\alias{pie_discover}
\title{Discover templates for \code{tastypie}}
\usage{
pie_discover(which = c("all", "bake", "pro"))
}
\arguments{
\item{which}{Allows to select a subset of the available templates. \cr
\cr
If \code{"all"}, the template is randomly chosen among all the available ones. \cr
If \code{"bake"}, the template is randomly chosen among the ones that can be used
through \code{\link{pie_bake}}.\cr
If \code{"pro"}, the template is randomly chosen among the (more complex) ones
that can be used through \code{\link{pie_bake_pro}}.\cr
\cr
The default value is \code{"all"}.}
}
\value{
A ggplot object.
In particular, this function returns a pie (or similar) chart according to a random
choice of template and the other features.
}
\description{
This function allows to user to find out a random combination of templates,
number of groups and features in order to get an idea of the many available
plots in the package \code{tastypie}.
}
\examples{
pie_discover()
pie_discover("pro")
}
\seealso{
See all the available templates displayed
\href{https://paolodalena.github.io/tastypie/articles/available_templates.html}{here}!
}
