% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{supertaxa}
\alias{supertaxa}
\title{Get all supertaxa of a taxon}
\arguments{
\item{obj}{The \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object containing taxon
information to be queried.}

\item{subset}{(\code{character}) \code{taxon_ids} or indexes of
\code{taxon_data} for which supertaxa will be returned. Default: All taxa
in \code{obj} will be used.}

\item{recursive}{(\code{logical} or \code{numeric}) If \code{FALSE}, only return the
supertaxa one rank above the target taxa. If \code{TRUE}, return all the
supertaxa of every supertaxa, etc. Positive numbers indicate the number of
recursions (i.e. number of ranks above the target taxon to return). \code{1} is
equivalent to \code{FALSE}. Negative numbers are equivalent to \code{TRUE}.}

\item{simplify}{(\code{logical}) If \code{TRUE}, then combine all the results into a
single vector of unique values.}

\item{include_input}{(\code{logical}) If \code{TRUE}, the input taxa are included in
the output}

\item{value}{What data to return. Any result of \code{\link[=all_names]{all_names()}} can be used, but it
usually only makes sense to use data that has an associated taxon id.}

\item{na}{(\code{logical}) If \code{TRUE}, return \code{NA} where information
is not available.}
}
\value{
If \code{simplify = FALSE}, then a list of vectors are returned
corresponding to the \code{subset} argument. If \code{simplify = TRUE},
then unique values are returned in a single vector.
}
\description{
Return data for supertaxa (i.e. all taxa the target
taxa are a part of) of each taxon in a \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object.
\preformatted{
obj$supertaxa(subset = NULL, recursive = TRUE,
  simplify = FALSE, include_input = FALSE,
  value = NULL, na = FALSE)
supertaxa(obj, subset = NULL, recursive = TRUE,
  simplify = FALSE, include_input = FALSE,
  value = NULL, na = FALSE)}
}
\examples{
# return the indexes for supertaxa for each taxon
supertaxa(ex_taxmap)

# Only return data for some taxa using taxon indexes
supertaxa(ex_taxmap, subset = 1:3)

# Only return data for some taxa using taxon ids
supertaxa(ex_taxmap, subset = c("3", "4"))

# Only return data for some taxa using logical tests
supertaxa(ex_taxmap, subset = taxon_ranks == "species")

# Only return supertaxa one level above
supertaxa(ex_taxmap, recursive = FALSE)

# Only return supertaxa some number of ranks above
supertaxa(ex_taxmap, recursive = 2)

# Return something besides taxon indexes
supertaxa(ex_taxmap, value = "taxon_names")
}
\seealso{
Other taxonomy indexing functions: \code{\link{leaves}},
  \code{\link{roots}}, \code{\link{stems}},
  \code{\link{subtaxa}}
}
