% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate_db.R
\name{mutate_db}
\alias{mutate_db}
\title{Add new variables to a database}
\usage{
mutate_db(.data, r_fn, col, new_column, n = 5000L, ...)
}
\arguments{
\item{.data}{A \link[dplyr:tbl]{dplyr::tbl} that uses a database connection, \code{tbl_dbi} class.}

\item{r_fn}{any R function that can be called on a vector (column)
of the table}

\item{col}{the name of the column to which the R function is applied.
(Note, \code{\link[dplyr:mutate]{dplyr::mutate()}} can operate on an arbitrary list of columns,
this function only operates on a single column at this time...)}

\item{new_column}{column name for the new column.}

\item{n}{the number of rows included in each chunk, see \code{\link[DBI:dbFetch]{DBI::dbFetch()}}}

\item{...}{named arguments to be passed to \code{r_fn}}
}
\value{
a dplyr tbl connection to the temporary table in the database
}
\description{
\code{\link[dplyr:mutate]{dplyr::mutate()}} cannot pass arbitrary R functions over a
database connection. This function provides a way to work
around this, by querying the data in chunks
and applying the function to each chunk, which is then
appended back out to a temporary table.
}
