% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.stPredict.R
\name{plot.stPredict}
\alias{plot.stPredict}
\title{Plot stPredict objects}
\usage{
\method{plot}{stPredict}(
  x,
  type = "prediction",
  t = NULL,
  stFit = NULL,
  stData = NULL,
  err.comparison = NULL,
  err.var = NULL,
  err.lab = err.var,
  pattern = 1,
  dots = NULL,
  burn = 1,
  signif.telecon = F,
  ...
)
}
\arguments{
\item{x}{Object of class stPredict to plot.}

\item{type}{One of the following options to specify what type of plot to build
\describe{
  \item{prediction}{ Spatial plot of predicted response variable for 
    a given timepoint t. }
  \item{residual}{ Spatial plot of residual for a given timepoint t.  
    Note, this plot is only available if the model has been
    evaluated and the predictions have been compared to another response
    dataset. }
  \item{observed}{ Spatial plot of observed response variable for a given
    timepoint t. Note, this plot is only available if the model has been
    evaluated and the predictions have been compared to another response
    dataset.  }
  \item{standard_error (or 'se')}{ Spatial plot of prediction standard 
    errors for a given timepoint t.}
  \item{local}{ Spatial plot of the local components of the
    response variable for a given timepoint t.}
  \item{remote}{ Spatial plot of the remote components of the 
    response variable for a given timepoint t.}
  \item{w}{ Spatial plot of the spatial noise component of the reponse 
    variable for a given timepoint t.}
  \item{correlation}{ Scatterplot of observed vs. predicted response 
    variables for a given timepoint t.  Note, this plot is only available 
    if the model has been evaluated and the predictions have been compared 
    to another response dataset.   }
  \item{teleconnection}{ Spatial plot of remote coefficients associated
    with a location coord.s in the spatial response domain. }
  \item{teleconnection_knot}{ Spatial plot of remote knot coefficients 
    associated with a location coord.s in the spatial response domain. }
  \item{teleconnection_knot_transect}{ }
  \item{errors}{ Series of plots that measure overall prediction error 
    across prediction timepoints. }
  \item{cat.prediction}{ Spatial plot of the predicted response variable
    category (i.e., above/below average) for a given timepoint t. }
  \item{truth}{ Note, this plot is only available if the model has been
    evaluated and the predictions have been compared to another response
    dataset. }
  \item{residual}{ Note, this plot is only available if the model has been
    evaluated and the predictions have been compared to another response
    dataset. }
  \item{eof_alpha_knots}{ A map of the local domain where the plotted colors
    show the remote influence coefficients mapped onto the eof pattern
    specified by the "pattern" argument.   }
}}

\item{t}{timepoint to plot.  Will automatically plot the first timepoint if
t=NULL.}

\item{stFit}{Object of class stFit to provide related
information and structures for plotting estimated teleconnection effects}

\item{stData}{Object of class stData to provide coordinate and related
information for plotting estimated teleconnection effects}

\item{err.comparison}{data.frame with Year column  and a column for a variable
that will be used to plot annual errors against}

\item{err.var}{name of variable in err.comparison for plotting against}

\item{err.lab}{label for name of variable in err.comparison for plotting against}

\item{pattern}{if type=='eof_alpha_knots', this specified which eof the remote 
coefficients should be mapped onto and then plotted over the local domain}

\item{dots}{additional named arguments with defaults to pass to additional 
functions}

\item{burn}{number of observations to exclude from graph}

\item{signif.telecon}{TRUE to highlight significant teleconnection effects}

\item{...}{additional arguments to be passed to lower-level plotting functions}
}
\value{
a ggplot object with the specified map
}
\description{
This function provides basic plotting for telefit package data.
}
\examples{

data("coprecip.predict")
p = plot(coprecip.predict, t=1981)

}
