% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ttm.R
\name{ttm}
\alias{ttm}
\title{Test that with multiple attempts}
\usage{
ttm(n, expr, verbose = 0)
}
\arguments{
\item{n}{Maximum number of attempts}

\item{expr}{Expression to evaluate}

\item{verbose}{Amount that should be printed}
}
\value{
Nothing
}
\description{
Test that with multiple attempts
}
\examples{

set.seed(0)

# 1 attempt, all pass
ttm(1, {
  ttm_expect_true(TRUE)
  ttm_expect_true(1 == 1)
  ttm_expect_true(all(1:5 == 1:5))
})

# Fails first 10 times, then passes
ttm(100, {
  x <- runif(1)
  print(x)
  ttm_expect_true(x < 0.1)
})

# Will always fail regardless of number of attempts
try({
  ttm(3, {
    ttm_expect_true(1 == 2)
  })
})
}
