###################################################
### chunk number 1: 
###################################################
library(tgp)
seed <- 0; set.seed(seed)


###################################################
### chunk number 2: 
###################################################
library(tgp)
seed <- 0; set.seed(seed)


###################################################
### chunk number 3: 
###################################################
rosenbrock <- function(x){ 
  x <- matrix(x, ncol=2)
  100*(x[,1]^2 - x[,2])^2 + (x[,1] - 1)^2 
}


###################################################
### chunk number 4: 
###################################################
rosenbrock(c(1,1))


###################################################
### chunk number 5: 
###################################################
rect <- cbind(c(-1,-1),c(5,5))
X <- lhs(40, rect)
Z <- rosenbrock(X)


###################################################
### chunk number 6: 
###################################################
XX <- lhs(200, rect)
rfit <- bgp(X,Z,XX,improv=c(1,10), verb=0)


###################################################
### chunk number 7: 
###################################################
cbind(rfit$improv,XX)[rfit$improv$rank <= 10,]


###################################################
### chunk number 8: optim-fit1
###################################################
plot(rfit, as="improv")


###################################################
### chunk number 9: 
###################################################
graphics.off()


###################################################
### chunk number 10: optim-fit2
###################################################
rfit2 <- predict.tgp(rfit, XX=XX, BTE=c(1,1000,1), improv=c(5,20), verb=0) 
plot(rfit2, layout="as", as="improv")


###################################################
### chunk number 11: 
###################################################
graphics.off()


###################################################
### chunk number 12: 
###################################################
f <- function(x) { exp2d.Z(x)$Z }


###################################################
### chunk number 13: 
###################################################
rect <- rbind(c(-2,6), c(-2,6))
X <- lhs(20, rect)
Z <- f(X)


###################################################
### chunk number 14: 
###################################################
out <- progress <- NULL
for(i in 1:20) {
  
  ## get recommendations for the next point to sample
  out <- optim.step.tgp(f, X=X, Z=Z, rect=rect, prev=out, verb=0)

  ## add in the inputs, and newly sampled outputs
  X <- rbind(X, out$X)
  Z <- c(Z, f(out$X))
  
  ## keep track of progress and best optimum
  progress <- rbind(progress, out$progress)
}


###################################################
### chunk number 15: optim-progress
###################################################
par(mfrow=c(1,2))
matplot(progress[,1:2], main="x progress",
        xlab="rounds", ylab="x[,1:2]", type="l", lwd=2)
plot(log(progress$improv), type="l", main="max log improv",
     xlab="rounds", ylab="max log(improv)")


###################################################
### chunk number 16: 
###################################################
graphics.off()


###################################################
### chunk number 17: 
###################################################
out$progress[1:2]


###################################################
### chunk number 18: 
###################################################
formals(optim)$method


###################################################
### chunk number 19: 
###################################################
formals(optim.ptgpf)$method


