% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyboot.R
\name{tidyboot.numeric}
\alias{tidyboot.numeric}
\title{Non-parametric bootstrap for numeric vector data}
\usage{
\method{tidyboot}{numeric}(data, summary_function = mean,
  statistics_functions, nboot = 1000, size = 1, replace = TRUE, ...)
}
\arguments{
\item{data}{A numeric vector of data to bootstrap over.}

\item{summary_function}{A function to be computed over each set of samples.
This function needs to take a vector and return a single number (defaults
to \code{mean}).}

\item{statistics_functions}{A named list of functions to be computed over the
set of summary values from all samples.}

\item{nboot}{The number of bootstrap samples to take (defaults to
\code{1000}).}

\item{size}{The fraction of items to sample (defaults to 1).}

\item{replace}{Logical indicating whether to sample with replacement
(defaults to \code{TRUE}).}

\item{...}{Other arguments passed from generic.}
}
\description{
Computes arbitrary bootstrap statistics on univariate data.
}
\examples{
## Mean and 95\% confidence interval for 500 samples from a normal distribution
x <- rnorm(500, mean = 0, sd = 1)
tidyboot(x, statistics_functions = list("ci_lower" = ci_lower,
                                        "mean" = mean,
                                        "ci_upper" = ci_upper))
}
