% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms.R
\name{hz_to_bark}
\alias{hz_to_bark}
\title{Hz to Bark}
\usage{
hz_to_bark(hz)
}
\arguments{
\item{hz}{Frequency in Hz}
}
\value{
A vector of bark scaled values
}
\description{
Converts Hz to Bark
}
\details{
\deqn{
\hat{b} = \frac{26.81 hz}{1960 + hz} - 0.53
}
\deqn{
b = \begin{cases}
\hat{b} + 0.15(2-\hat{b}) & \text{if}~\hat{b} < 2\\
\hat{b} + 0.22(\hat{b} - 20.1) & \text{if}~\hat{b} > 20.1\\
\hat{b} & \text{otherwise}
\end{cases}
}
}
\examples{
hz <- seq(150, 2000, length = 100)
bark <- hz_to_bark(hz)
plot(hz, bark)

}
\references{
Traunmüller, H. (1990). Analytical expressions for the tonotopic
sensory scale. The Journal of the Acoustical Society of America,
88(1), 97–100. \doi{10.1121/1.399849}
}
