% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust.R
\name{adjust_theme_details}
\alias{adjust_theme_details}
\title{Adjust theme details}
\usage{
adjust_theme_details(plot, ...)
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{...}{Arguments passed on to the \code{geom} function.}
}
\value{
A \code{tidyplot} object.
}
\description{
This function is a wrapper around \code{ggplot2::theme()}. To use the required theme
helper functions \code{ggplot2::element_blank()}, \code{ggplot2::element_rect()},
\code{ggplot2::element_line()}, and \code{ggplot2::element_text()} you need to either load
the ggplot2 package via \code{library(ggplot2)} or use the \verb{ggplot2::} prefix as shown above.
}
\examples{
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_data_points_beeswarm() |>
  add_mean_bar(alpha = 0.4) |>
  adjust_theme_details(plot.background = ggplot2::element_rect(fill = "#FFEBFF"))

}
