% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-like.R
\name{categorical_test_by}
\alias{categorical_test_by}
\title{Categorical test in a pipe}
\usage{
categorical_test_by(
  .tbl,
  var1,
  var2,
  na.rm = T,
  test_function_generator = NULL,
  ...
)
}
\arguments{
\item{.tbl}{A data frame}

\item{var1}{First column to count by}

\item{var2}{Second column to count by}

\item{na.rm}{Shall NA values be removed prior to counting?}

\item{test_function_generator}{A function receiving the matrix to test and
returning a named vector with the test function to use. The default uses
fisher.test if one count is 5 or lower, otherwise chisq.test.
Test functions must return a value with at least one component named "p.value".}

\item{...}{Passed on to the test function}
}
\value{
A one-row data frame with the columns:\itemize{
    \item "var1,var2": The tested variables
    \item "test": Label of the test function (default: fisher or chisq)
    \item "p-value": P value
    \item "result": List column with full result object (default: htest)
    \item "contingency_table": List column with contingency table data frame
    as return by \code{\link{contingency_table_by}}
    }
}
\description{
Performs classical categorical tests on two columns of a
data frame.
Per default, will perform \code{\link{chisq.test}}
or \code{\link{fisher.test}} on the
contingency table created by var1 and var2.
}
\details{
Returns a one-line data frame as result and thus plays nicely
with for example \code{\link{map_dfr}}.
}
\examples{
library(magrittr)
if (requireNamespace("datasets", quietly = TRUE))
{
   mtcars \%>\% categorical_test_by(cyl >= 6, gear)
}
}
