% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipes-step_timeseries_signature.R
\name{step_timeseries_signature}
\alias{step_timeseries_signature}
\alias{tidy.step_timeseries_signature}
\title{Time Series Feature (Signature) Generator}
\usage{
step_timeseries_signature(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  columns = NULL,
  skip = FALSE,
  id = rand_id("timeseries_signature")
)

\method{tidy}{step_timeseries_signature}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables that will be used to create the new variables. The
selected variables should have class \code{Date} or
\code{POSIXct}. See \code{\link[recipes:selections]{recipes::selections()}} for more details.
For the \code{tidy} method, these are not currently used.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new variable columns created by the original variables
will be used as predictors in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of variables that will be
used as inputs. This field is a placeholder and will be
populated once \code{recipes::prep()} is used.}

\item{skip}{A logical. Should the step be skipped when the recipe is
baked by bake.recipe()? While all operations are baked when prep.recipe()
is run, some operations may not be able to be conducted on new data
(e.g. processing the outcome variable(s)). Care should be taken when
using skip = TRUE as it may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_timeseries_signature} object.}
}
\value{
For \code{step_timeseries_signature}, an updated version of recipe with
the new step added to the sequence of existing steps (if any).
For the \code{tidy} method, a tibble with columns \code{terms}
(the selectors or variables selected), \code{value} (the feature
names).
}
\description{
\code{step_timeseries_signature} creates a a \emph{specification} of a recipe
step that will convert date or date-time data into many
features that can aid in machine learning with time-series data
}
\details{
\strong{Date Variable}
Unlike other steps, \code{step_timeseries_signature} does \emph{not}
remove the original date variables. \code{\link[recipes:step_rm]{recipes::step_rm()}} can be
used for this purpose.

\strong{Scaling index.num}
The \code{index.num} feature created has a large magnitude (number of seconds since 1970-01-01).
It's a good idea to scale and center this feature (e.g. use  \code{\link[recipes:step_normalize]{recipes::step_normalize()}}).

\strong{Removing Unnecessary Features}
By default, many features are created automatically. Unnecessary features can
be removed using \code{\link[recipes:step_rm]{recipes::step_rm()}}.
}
\examples{
library(recipes)
library(dplyr)

FB_tbl <- FANG \%>\% dplyr::filter(symbol == "FB")

# Create a recipe object with a timeseries signature step
rec_obj <- recipe(adjusted ~ ., data = FB_tbl) \%>\%
    step_timeseries_signature(date)

# View the recipe object
rec_obj

# Prepare the recipe object
prep(rec_obj)

# Bake the recipe object - Adds the Time Series Signature
bake(prep(rec_obj), FB_tbl)

# Tidy shows which features have been added during the 1st step
#  in this case, step 1 is the step_timeseries_signature step
tidy(rec_obj)
tidy(rec_obj, number = 1)



}
\seealso{
Time Series Analysis:
\itemize{
\item Engineered Features: \code{\link[=step_timeseries_signature]{step_timeseries_signature()}}, \code{\link[=step_holiday_signature]{step_holiday_signature()}}, \code{\link[=step_fourier]{step_fourier()}}
\item Diffs & Lags \code{\link[=step_diff]{step_diff()}}, \code{recipes::step_lag()}
\item Smoothing: \code{\link[=step_slidify]{step_slidify()}}, \code{\link[=step_smooth]{step_smooth()}}
\item Variance Reduction: \code{\link[=step_box_cox]{step_box_cox()}}
\item Imputation: \code{\link[=step_ts_impute]{step_ts_impute()}}, \code{\link[=step_ts_clean]{step_ts_clean()}}
\item Padding: \code{\link[=step_ts_pad]{step_ts_pad()}}
}

Main Recipe Functions:
\itemize{
\item \code{recipes::recipe()}
\item \code{recipes::prep()}
\item \code{recipes::bake()}
}
}
