% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/business.R
\name{daycount_frac}
\alias{daycount_frac}
\title{Differences Between Dates as Year Fractions / Accrual Factors}
\usage{
daycount_frac(d1, d2, convention)
}
\arguments{
\item{d1}{an object of \code{tind} class representing start date(s)
or an R object coercible to it.}

\item{d2}{an object of \code{tind} class representing end date(s)
or an R object coercible to it.}

\item{convention}{a chacter string determining day count convention to be used,
see Details.}
}
\value{
A numeric vector.
}
\description{
This function computes difference between two dates as year fraction
given day count convention.
}
\details{
Currently, the following day count conventions are supported:
\describe{
    \item{\code{30/360}}{also known as 30/360 Bond Basis or 360/360,
described in ISDA 2006 Section 4.16(f). The formula is as follows:
\deqn{\frac{360(y_2-y_1) + 30(m_2-m_1) + (d_2-d_1)}{360},}
where \eqn{y} denotes year, \eqn{m} month, \eqn{d} day of month.
Dates are adjusted accoring to the following rules: if \eqn{d_1} is 31,
it is changed to 30, if \eqn{d_2} is 31 and \eqn{d_1} is 30 or 31, \eqn{d_2}
is changed to 30.}
    \item{\code{30E/360}}{also known as Eurobond basis, 30/360 ICMA or 30/360 ISMA,
described in ICMA Rule 251.1(ii), 251.2 and ISDA 2006 Section 4.16(g).
The formula used is the same as above but the adjustment of dates is different:
if \eqn{d_1} or \eqn{d_2} is 31, it is changed to 30.}
    \item{\code{ACT/ACT}}{also known as Actual/Actual and Actual/Actual ISDA,
described in ISDA 2006 Section 4.16(b). Days between the dates (start included,
end excluded) are divided into two groups: falling in leap and non-leap years.
The number of days in leap years is divided by 366, the number of days in
non-leap years is divided by 365. Finally, the two fractions are added.}
    \item{\code{ACT/365F}}{also known as Actual/365 Fixed, described in
ISDA 2006 Section 4.16(d). Difference in days between dates divided by 365. }
    \item{\code{ACT/360}}{also known as Actual/360, described in
ISDA 2006 Section 4.16(e). Difference in days between dates divided by 360. }
}
}
\examples{
daycount_frac("2023-01-29", "2023-03-31", "30/360")
1/6 + 2/360
daycount_frac("2023-01-29", "2023-03-31", "30E/360")
1/6 + 1/360
daycount_frac("2023-01-29", "2023-03-31", "ACT/ACT")
61 / 365
daycount_frac("2024-01-29", "2024-03-31", "ACT/ACT")
62 / 366
daycount_frac("2023-01-29", "2023-03-31", "ACT/365F")
61 / 365
daycount_frac("2024-01-29", "2024-03-31", "ACT/365F")
62 / 365
daycount_frac("2023-01-29", "2023-03-31", "ACT/360")
61 / 360
daycount_frac("2024-01-29", "2024-03-31", "ACT/360")
62 / 360

}
\references{
International Swaps and Derivatives Association, Inc.,
\emph{2006 ISDA Definitions}, New York, 2006.
}
\seealso{
\code{\link{year_frac}}, \code{\link{bizday}}.
}
