% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{isolate_nodes}
\alias{isolate_nodes}
\title{Isolate nodes in a document}
\usage{
isolate_nodes(nodelist, type = "context")
}
\arguments{
\item{nodelist}{an object of class \code{xml_nodeset} OR \code{xml_node} OR a list of
either.}

\item{type}{a string of either "context" (default), "censor", or "list"}
}
\value{
a list of two elements:
\itemize{
\item doc: a copy of the document with the nodes isolated depending on the
context
\item key: a string used to tag nodes that are isolated via the \code{tnk-key}
attribute
}
}
\description{
Isolate nodes in a document
}
\details{
\code{isolate_nodes()}is the workhorse for the \code{show} family of functions. These
functions will create a copy of the document with the nodes present in
\code{nodelist} isolated. It has the following switches for "type":
\itemize{
\item "context" include the nodes within the block context of the document.
For example, if the nodelist contains links in headings, paragraphs, and
lists, those links will appear within these blocks. When \code{mark = TRUE},
ellipses \verb{[...]} will be added to indicate hidden content.
\item "censor" by default will replace all non-whitespace characters with a
censor character. This is controlled by \code{tinkr.censor.regex} and
\code{tinkr.censor.mark}
\item "list" creates a new document and copies over the nodes so they appear
as a list of paragraphs.
}
}
\examples{
\dontshow{if (isTRUE(as.logical(Sys.getenv("NOT_CRAN", "false")))) withAutoprint(\{ # examplesIf}
path <- system.file("extdata", "show-example.md", package = "tinkr")
y <- tinkr::yarn$new(path, sourcepos = TRUE)
y$protect_math()$protect_curly()
items <- xml2::xml_find_all(y$body, ".//md:item", tinkr::md_ns())
tnk <- asNamespace("tinkr")
tnk$isolate_nodes(items, type = "context")
tnk$isolate_nodes(items, type = "censor")
tnk$isolate_nodes(items, type = "list")
\dontshow{\}) # examplesIf}
}
\seealso{
Other nodeset isolation functions: 
\code{\link{provision_isolation}()}
}
\concept{nodeset isolation functions}
\keyword{internal}
