% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tipping_point_model_based.R
\name{tipping_point_model_based}
\alias{tipping_point_model_based}
\title{Tipping Point Analysis (Model-Based)}
\usage{
tipping_point_model_based(
  dat,
  reason,
  impute,
  imputation_model = "weibull",
  J = 10,
  tipping_range = seq(0.05, 1, by = 0.05),
  cox_fit = NULL,
  verbose = FALSE,
  seed = 12345
)
}
\arguments{
\item{dat}{data.frame containing at least 5 columns: TRT01P (treatment arm as factor), AVAL (survival time), EVENT (event indicator), CNSRRS (censoring reason) and MAXAVAL (maximum potential survival time, duration between randomization to data cut-off)}

\item{reason}{Vector specifying censoring reasons to be imputed.}

\item{impute}{a string specifying the treatment arm(s) which require imputation. It must be one of the arms from variable TRT01P, the first level of TRT01P is considered as the control arm.}

\item{imputation_model}{used to fit model to observed data (should be "Weibull" or "exponential")}

\item{J}{numeric indicating number of imputations.}

\item{tipping_range}{Numeric vector. Hazard inflation (>1) for treatment arm imputation or deflation (<1) range for control arm imputation.}

\item{cox_fit}{A Cox model that will be used to calculate HRs on imputed datasets.
In case of inclusion of stratification factors or covariates, conditional HR will be used.}

\item{verbose}{Logical. If \code{TRUE}, prints progress and analysis details.}

\item{seed}{Integer. Random seed for reproducibility.}
}
\value{
A \code{tipse} object containing:
\describe{
\item{original data}{Input argument from 'data'.}
\item{imputation_results}{A data frame of combined pooled model results across tipping points}
\item{original_HR}{The original hazard ratio.}
\item{reason_to_impute}{Input argument from 'reason'.}
\item{arm_to_impute}{Input argument from 'impute'.}
\item{method_to_impute}{Input argument from 'method'.}
\item{imputation_data}{A list of imputed datasets for each tipping point value.}
}
}
\description{
Performs a model-based tipping point analysis on time-to-event data by
repeatedly imputing censored observations under varying assumptions. The model-based
framework assumes that censored patients have a multiple of hazard fitted via a parametric survival model
compared to the rest of patients in the same arm (Akinson et al, 2019).
}
\details{
The \strong{model-based tipping point analysis} provides a reproducible and intuitive
framework for exploring the robustness of treatment effects in time-to-event
(survival) endpoints when censoring may differ between study arms.

A parametric survival model is fitted using maximum likelihood.
This function applies a hazard deflation on control arm or hazard inflation on treatment
arm, and impute survival times based on the parametric model with additional sampling of the parameters from a multivariate normal distribution.
This imputation procedure is iterated across a range of
tipping point parameters \code{tipping_range}. For each parameter value:
\enumerate{
\item Multiple imputed datasets are generated (\code{J} replicates), where censored
observations in the selected arm are reassigned
event times according to the imputation method.
\item A Cox proportional hazards model is fitted to each imputed dataset.
\item Model estimates are pooled using \strong{Rubin’s rules} to obtain a combined
hazard ratio and confidence interval for that tipping point parameter.
}

The process yields a series of results showing how the treatment effect changes
as increasingly conservative or optimistic assumptions are made about censored
observations. The \emph{tipping point} is defined as the smallest value (hazard inflation)
or biggest value (hazard deflation) of the sensitivity parameter for which the upper
bound of the hazard ratio confidence interval crosses 1 - i.e., where the
apparent treatment benefit is lost.
}
\examples{
cox1 <- survival::coxph(Surv(AVAL, EVENT) ~ TRT01P, data = codebreak200)
result <- tipping_point_model_based(
  dat = codebreak200,
  reason = "Early dropout",
  impute = "docetaxel",
  imputation_model = "weibull",
  J = 10,
  tipping_range = seq(0.1, 1, by = 0.05),
  cox_fit = cox1,
  verbose = TRUE,
  seed = 12345
)
}
\references{
Atkinson, A., Kenward, M. G., Clayton, T., & Carpenter, J. R. (2019).
Reference‐based sensitivity analysis for time‐to‐event data. Pharmaceutical statistics, 18(6), 645-658.
}
