% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_repo.R
\name{setup_subdirectory}
\alias{setup_subdirectory}
\title{Initialize a new subdirectory in an existing repository, TNTP style.}
\usage{
setup_subdirectory(project_path, subfolder, proj_name, analyst_name)
}
\arguments{
\item{project_path}{the path to the main project directory. To use the current project, use `project_path = here::here()`.}

\item{subfolder}{a character vector containing the concise name of a project subfolder.
E.g., if the repository is the name of a city "Anywhere City", a project subfolder might be
"ela_access" or "aps_talent_landscape").}

\item{proj_name}{the longer, full name of the subfolder project.  This will
appear in the subfolder's README.md file.}

\item{analyst_name}{the name(s) of the analysts currently working on the subfolder
project.  This will appear in the subfolder's README.md file.}
}
\value{
nothing
}
\description{
A repository might represent a region, like "Anywhere City",
or a major client or contract, like "Midwestern Charter Network.
Within that repo you would have a subfolder for each analysis project.
This function creates such a subfolder and populates it with folders and a README.

To use: within an existing repository on Bitbucket, set your your working
directory to that folder and run this function to create a sub-folder.

Use \code{setup_repo()} in a blank new repository to add the first project subfolder
and create the RProject and .gitignore files.  Add subsequent analysis project folders
with this function.
}
\examples{
# Setting up in a temporary directory
setup_subdirectory(tempdir(),
                   subfolder = "ela_access",
                   proj_name = "Equitable Access to Grade-Level ELA",
                   analyst_name = "Dustin Pashouwer and Sam Firke")
}
