% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional.R
\name{functional_apply_probability_distribution}
\alias{functional_apply_probability_distribution}
\title{Probability Distribution Apply (functional)}
\usage{
functional_apply_probability_distribution(waveform, density_function = "TPDF")
}
\arguments{
\item{waveform}{(Tensor): Tensor of audio of dimension (..., time)}

\item{density_function}{(str, optional): The density function of a
continuous random variable  (Default: \code{"TPDF"})
Options: Triangular Probability Density Function - \code{TPDF}
Rectangular Probability Density Function - \code{RPDF}
Gaussian Probability Density Function - \code{GPDF}}
}
\value{
\code{tensor}: waveform dithered with TPDF
}
\description{
Apply a probability distribution function on a waveform.
}
\details{
\itemize{
\item \strong{Triangular} probability density function  (TPDF) dither noise has a
triangular distribution; values in the center of the range have a higher
probability of occurring.
\item \strong{Rectangular} probability density function  (RPDF) dither noise has a
uniform distribution; any value in the specified range has the same
probability of occurring.
\item \strong{Gaussian} probability density function  (GPDF) has a normal distribution.
The relationship of probabilities of results follows a bell-shaped,
or Gaussian curve, typical of dither generated by analog sources.
}
}
