% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyFunctions.R
\name{findThreshold}
\alias{findThreshold}
\title{Find threshold}
\usage{
findThreshold(images, frame = 1, colorimages = NULL)
}
\arguments{
\item{images}{Array containing images containing all moving particles,
as obtained from \code{\link{subtractBackground}}.}

\item{frame}{Number specifying which frame to use. Default is frame 1.}

\item{colorimages}{Array containing original color images. By default, 
the original color images are obtained from the global environment.}
}
\value{
Returns the number that is interactively chosen by the user. Use 
this threshold value in \code{identifyParticles}.
}
\description{
This function can help to find a threshold value to distinguish noise from 
particles of interest.
}
\examples{
\dontrun{
dir.create("images")
## Create image sequence
traj <- simulTrajec(path="images",
                    nframes=30,nIndividuals=20,domain="square",
                    h=0.01,rho=0.9,
                    sizes=runif(20,0.004,0.006))
## Load images
dir <- "images"
allFullImages <- loadImages (dirPictures=dir,nImages=1:30)
stillBack <- createBackground(allFullImages,method="mean")
allImages <- subtractBackground(stillBack)
thr <- findThreshold(allImages,frame=10)
}
}
\author{
Marjolein Bruijning, Caspar A. Hallmann & Marco D. Visser
}
