% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_mri_image.R
\docType{class}
\name{MriImage-class}
\alias{MriImage-class}
\alias{MriImage}
\title{The MriImage class}
\description{
This class represents an MRI image. An object of this class is made up of
some voxel data, stored as a sparse or dense numeric array, and some
metadata, such as the file it was read from, the voxel dimensions, and so
on. The group generic functions \code{\link{Math}}, \code{\link{Ops}} and
\code{\link{Summary}} are defined for this class, as are methods for
coercing to and from a standard \code{\link{array}}.
}
\section{Fields}{

\describe{
\item{\code{imageDims}}{Integer vector of dimensions}

\item{\code{voxelDims}}{Numeric vector of pixel/voxel spacings}

\item{\code{voxelDimUnits}}{Character vector of spatial and/or temporal spacing
units. Millimetres and seconds (i.e., c("mm","s")) are typical}

\item{\code{source}}{String naming the file(s) that the image was read from. This
is reset to the empty string if the image is modified}

\item{\code{origin}}{Numeric vector giving the spatial coordinate origin}

\item{\code{xform}}{Numeric matrix giving the NIfTI-style xform matrix associated
with the image, which indicates its orientation}

\item{\code{reordered}}{Logical value indicating whether the image has been
reordered. See \code{\link{reorderMriImage}}}

\item{\code{tags}}{Named list of arbitrary DICOM-style tags}

\item{\code{data}}{Sparse or dense array of data, or \code{NULL}}
}}

\section{Methods}{

\describe{
\item{\code{apply(...)}}{Apply a function to the margins of the image}

\item{\code{binarise()}}{Binarise the image by setting nonzero values to one}

\item{\code{fill(value)}}{Fill the image with a particular value}

\item{\code{find(fun = NULL, ..., array = TRUE)}}{Find voxels whose values are not zero, or satisfy a function}

\item{\code{getDataAtPoint(...)}}{Obtain the value of the image at a particular point}

\item{\code{getMetadata()}}{Obtain a version of the image with any data removed}

\item{\code{getNonzeroIndices(array = TRUE, positiveOnly = FALSE)}}{Find voxels whose values are not zero}

\item{\code{getSlice(dim, loc)}}{Extract data from a slice of the image along one dimension}

\item{\code{getSparseness()}}{Obtain the proportion of zeroes in the image}

\item{\code{getTags(keys = NULL)}}{Retrieve some or all of the tags stored with the image}

\item{\code{getXform(implicit = TRUE)}}{Retrieve the stored or implicit xform matrix}

\item{\code{map(fun, ..., sparse = NULL)}}{Replace the current data with the result of a function}

\item{\code{mask(maskImage)}}{Mask the image, setting zero voxels in the mask to zero}

\item{\code{setData(newData)}}{Replace the data in the image}

\item{\code{setOrigin(newOrigin)}}{Update the origin of the image}

\item{\code{setSource(newSource)}}{Update the source of the image}

\item{\code{setTags(..., merge = FALSE)}}{Add, replace or merge metadata tags}

\item{\code{setXform(newXform)}}{Update the xform matrix associated with the image}

\item{\code{summarise()}}{Summarise key aspects of the object}

\item{\code{threshold(level, defaultValue = 0)}}{Threshold the image by setting values below the threshold level to zero}
}}

