% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{where}
\alias{where}
\title{Compact conditional values}
\usage{
where(condition, value, fallback = NULL)
}
\arguments{
\item{condition}{An expression that resolves to a single logical value.}

\item{value, fallback}{Any expression.}
}
\value{
\code{value}, if \code{condition} evaluates to \code{TRUE};
  otherwise \code{fallback}.
}
\description{
This simple function checks whether its first argument is a logical value
that evaluates to \code{TRUE}. If so, it returns its second argument. If
not, it returns its third argument.
}
\details{
This function differs from the standard \code{\link{ifelse}} function in
that it does not act elementwise, and that the third argument is optional,
defaulting to \code{NULL}.
}
\references{
Please cite the following reference when using TractoR in your
work:

J.D. Clayden, S. Muñoz Maniega, A.J. Storkey, M.D. King, M.E. Bastin & C.A.
Clark (2011). TractoR: Magnetic resonance imaging and tractography with R.
Journal of Statistical Software 44(8):1-18. \doi{10.18637/jss.v044.i08}.
}
\seealso{
ifelse
}
\author{
Jon Clayden
}
