% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/squeeze_tips.R
\name{squeeze_tips}
\alias{squeeze_tips}
\title{Slices a phylogenetic tree following a 'tipward' orientation}
\usage{
squeeze_tips(tree, time, criterion = "my", dropNodes = FALSE)
}
\arguments{
\item{tree}{phylo. An ultrametric phylogenetic tree in the "phylo" format.}

\item{time}{numeric. A value that determines the time, or accumulated phylogenetic diversity (PD), at which the tree should be cut.}

\item{criterion}{character string. The method for cutting the tree. It can be either "my" (million years) or "PD" (accumulated phylogenetic diversity). Default is "my".}

\item{dropNodes}{logical. A logical value indicating whether the nodes that were sliced (void nodes, presenting no branch length) should be preserved in the node matrix. Default is FALSE.}
}
\value{
The function returns a time-slice of an inputted phylogenetic tree in the "phylo" format, following a 'tipward' orientation.
}
\description{
This function slices a phylogenetic tree in a 'tipward' orientation, starting from the tips and moving towards the root of the tree.
}
\details{
\bold{Slicing approach}
The treesliceR package uses a simple approach for cutting phylogenies, which reduces branch lengths in relation to an inputted temporal threshold.
}
\examples{
# Generate a random tree
tree <- ape::rcoal(20)

# Slice "tipwardly" the phylogeny at 0.1 million years
tree <- squeeze_tips(tree, time = 0.1)

# Plot it
plot(tree)

}
\references{
See the tutorial on how to use this function on our \href{https://araujomat.github.io/treesliceR/articles/Intro-treesliceR.html}{website}.
}
\seealso{
Other slicing methods: \code{\link[=squeeze_root]{squeeze_root()}}, \code{\link[=squeeze_int]{squeeze_int()}}, \code{\link[=phylo_pieces]{phylo_pieces()}}, \code{\link[=prune_tips]{prune_tips()}}.
}
\author{
Matheus Lima de Araujo \href{mailto:matheusaraujolima@live.com}{matheusaraujolima@live.com}
}
