\name{TVAR.sim}
\alias{TVAR.sim}
\title{Simulation and bootstrap of multivariate Treshold Autoregressive model}
\description{
Estimate or bootstraps a multivariate Threshold VAR
}
\usage{
TVAR.sim(data,B,TVARobject, Thresh, nthresh=1, type=c("simul","boot", "check"), n=200, lag=1, include = c("const", "trend","none", "both"),  thDelay=1,  thVar=NULL, mTh=1, starting=NULL,  innov=rmnorm(n, mean=0, varcov=varcov), varcov=diag(1,k), show.parMat=FALSE, round=FALSE)
}


\value{
A matrix with the simulated/bootstraped series.
}
\arguments{
\item{data}{matrix of parameter to simulate}
\item{B}{Matrix of coefficients to simulate}
\item{TVARobject}{Object computed by function TVAR()}
\item{Thresh}{The threshold value(s). Vector of length nthresh}
\item{nthresh}{number of threshold (see details)}
\item{type}{Whether a bootstrap or simulation is to employ. See details}
\item{n}{Number of observations to create when type="simul"}
\item{lag}{Number of lags to include in each regime}
\item{include}{Type of deterministic regressors to include. NOT WORKING PROPERLY CURRENTLY if not const}
\item{thDelay}{'time delay' for the threshold variable (as multiple of embedding time delay d) PLEASE NOTE that the notation is currently different to univariate models in tsDyn. The left side variable is taken at time t, and not t+1 as in univariate cases.}
\item{thVar}{external transition variable}
\item{mTh}{combination of variables with same lag order for the transition variable. Either a single value (indicating which variable to take) or a combination}
\item{starting}{Starting values when a simulation with given parameter matrix is made}
\item{innov}{Innovations used for simulation. Should be matrix of dim nxk. By default multivariate normal.}
\item{varcov}{Variance-covariance matrix for the inov when default multivariate normal is used.}
\item{show.parMat}{Logical. Should the parameter matrix be shown? Usefull to understand how to give right input}
\item{round}{Rounds the series created to have the same digits (hopefully) as original series. Useful when t}
}
\details{
This function offers the possibility to generate series following a TVAR from two approaches: bootstrap or simulation.

When the parameter matrix is given, on can only simulate a VAR (nthresh=0) or TVAR (nthresh=1 or 2). One can have a specification with constant (default), trend, both or none (see arg include). Order in parameters is include/lags (VECM) and include/lags/include/lags for TVECM, hence, a matrix for a TVECM with 3 regimes, a const and a 2 lags would have 2 lines and 2*(1+4) columns. The innovations can be given by the user (a matrix of dim nxk, here n does not include the starting values!), by default it uses a multivariate normal distribution, with covariance matrix specified by varcov. The starting values (of dim lags x k) can be given. The user should take care for their choice, since it is not sure that the simulated values will cross the threshold even once.

The second possibility is to bootstrap the series. This is done on a object generated by TVECM (or VECM). A simple residual bootstrap is done. Alternatively, one can simulate the series with the same parameter matrix and with normal distributed residuals, corresponding to Monte-carlo simulations. One can alternatively give only the series, and then the function will call internally TVECM(). 

}
\seealso{
\code{\link{TVAR}} to estimate a TVAR, \code{\link{VAR.sim}} to simulate/bootstrap a VAR. 
}
\author{Matthieu Stigler}
\examples{
##simulate VAR as in Enders 2004, p 268
B1<-matrix(c(0.7, 0.2, 0.2, 0.7), 2)
var1<-TVAR.sim(B=B1,nthresh=0,n=100, type="simul", include="none")
ts.plot(var1, type="l", col=c(1,2))


B2<-rbind(c(0.5, 0.5, 0.5), c(0, 0.5, 0.5))
varcov<-matrix(c(1,0.2, 0.3, 1),2)
var2<-TVAR.sim(B=B2,nthresh=0,n=100, type="simul", include="const", varcov=varcov)
ts.plot(var2, type="l", col=c(1,2))


##Simulation of a TVAR with 1 threshold
B<-rbind(c(0.11928245, 1.00880447, -0.009974585, -0.089316, 0.95425564, 0.02592617),c(0.25283578, 0.09182279,  0.914763741, -0.0530613, 0.02248586, 0.94309347))
sim<-TVAR.sim(B=B,nthresh=1,n=500, type="simul",mTh=1, Thresh=5, starting=matrix(c(5.2, 5.5), nrow=1))

#estimate the new serie
TVAR(sim, lag=1, dummyToBothRegimes=TRUE)

##Bootstrap a TVAR with two threshold (three regimes)
data(zeroyld)
serie<-zeroyld
TVAR.sim(data=serie,nthresh=2, type="boot",mTh=1, Thresh=c(7,9))

##Check the bootstrap
cbind(TVAR.sim(data=serie,nthresh=2, type="check",mTh=1, Thresh=c(7,9)),serie)
}
\keyword{ ts }

