% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.2.1.R
\name{tsacf}
\alias{tsacf}
\alias{tspacf}
\alias{tsacov}
\alias{tsccf}
\alias{tsccov}
\alias{print.tsacf}
\alias{plot.tsacf}
\title{Auto- Covariance and -Correlation Function Estimation}
\usage{
## Autocorrelation Function (ACF)
tsacf(
  x, y = NULL, lag.max = 8, 
  type = c("correlation", "covariance", "partial", 
           "cross-correlation", "cross-covariance"), 
  show.plot = TRUE, na.action = na.omit, 
  demean = TRUE, alpha = 0.05, 
  x.name = NULL, title = NULL)

## Partial Autocorrelation Function (PACF)
tspacf(...)

## Autocovariance (ACOV)
tsacov(...)

## cross-correlation (CCF)
tsccf(...)

## cross-ovariance (CCOV)
tsccov(...)

\method{print}{tsacf}(x, digits = max(3L, getOption("digits") - 3L), ...)

\method{plot}{tsacf}(x, title = NULL, ...)
}
\arguments{
\item{x, y}{univariate time series object(s) or a numeric vector(s) or matrix/matrices, or a `\code{tsacf}` object.}

\item{lag.max}{maximum lag at which to calculate the acf. Default is \code{8}. Will be automatically limited to one less than the number of observations in the series. If the series has less than 8 observations.}

\item{type}{character string giving the type of acf to be computed. Allowed values are "correlation" (the default), "covariance", "partial", "cross-correlation", or "cross-covariance". Will be partially matched.}

\item{show.plot}{logical. If \code{TRUE}, the acf/pacf/acov will be plotted. Default is \code{TRUE}.}

\item{na.action}{function to be called to handle missing values. Default is \code{na.omit}.}

\item{demean}{logical. If \code{TRUE}, the covariances will be about the sample means. Default is \code{TRUE}.}

\item{alpha}{significance level. (1 - \code{alpha}) indicates is the confidence level of the prediction interval. Default is \code{0.05}.}

\item{x.name}{name of the series. If omitted here, the series name found by \code{tsname()} will be taken over here. If \code{tsname()} is \code{NULL}, the variable name will be used instead. Default is \code{NULL}.}

\item{title}{character string indicating the plot title.}

\item{...}{other printing or plotting parameters.}

\item{digits}{number of decimal digits displayed in the results.}
}
\value{
An object of class "\code{tsacf}", which is a list with the following elements:

\item{plot}{bar chart of the estimated ACF/PACF/ACOV. Only available if \code{save.plot} is \code{TRUE}.}

\item{acf, pacf, acov, ccf, ccov}{An array with the same dimensions as lag containing the estimated ACF/PACF/ACOV/CCF/CCOV.}

\item{clim}{upper limits of the estimated confidence intervals for each lag. Since confidence intervals are symmetrical around 0, the lower limits are simply the negative values of \code{clim}.}

\item{type}{type of correlation (same as the \code{type} argument).}

\item{n.used}{number of observations in the time series.}

\item{lag}{lags at which the acf is estimated.}

\item{x.name}{name of the time series for which forecasts was requested.}

\item{alpha}{significance level.}
}
\description{
The function `\code{tsacf}` computes (and by default plots) estimates of the autocorrelation function. Function \code{pacf} is the function used for the partial autocorrelations, and function \code{tsacov} computes the autocovariance function.
}
\details{
For \code{type = "correlation"} and \code{"covariance"}, the estimates are based on the sample covariance of \eqn{x_t} and \eqn{x_{t-k}} (lag 0 autocorrelation is fixed at 1 by convention.). For \code{"cross-correlation"} and \code{"cross-covariance"}, the estimates are based on the sample covariance of \eqn{x_t} and \eqn{y_{t-k}}.

By default, no missing values are allowed. However, by default, \code{na.action = na.omit}, the covariances are computed only from complete cases. This means that the estimate computed may well not be a valid autocorrelation sequence, and may contain missing values. Missing values are not allowed when computing the PACF of a multivariate time series.

The partial correlation coefficient is estimated by fitting autoregressive models of successively higher orders up to \code{lag.max}.

The lag is returned and plotted in units of time, and not numbers of observations.

Different from \code{\link{acf}}, the lags here are not converted based on the seasonal cycle length. It simply reflects the time lag \eqn{k} between \eqn{X_t} and \eqn{X_{t-k}}. Furthermore, the ACF/PACF/ACOV/CCF/CCOV plots are created using \code{ggplot2}.

The generic functions \code{plot} and \code{print} have both methods for objects of class "\code{tsacf}".

For `\code{cross-correlation}` and `\code{cross-covariance}`, positive lags indicate that y is shifted forward in time relative to x, while negative lags indicate y is shifted backward.
}
\examples{
# Autocorrelation (ACF)
airport.acf <- tsacf(airport$Travellers, lag.max = 24, show.plot = FALSE)
print(airport.acf, digits = 4)
plot(airport.acf)

# Partial Autocorrelation (PACF)
tspacf(airport$Travellers, lag.max = 24)

# Autocovariance (ACOV)
tsacov(airport$Travellers, lag.max = 24, show.plot = FALSE)

# Cross-Correlation (CCF)
tsccf(airport$AvgRain, airport$Travellers, lag.max = 24)

# Cross-Covariance (CCOV)
tsccov(airport$AvgRain, airport$Travellers, lag.max = 24)
}
\references{
Box, G. E. P., & Jenkins, G. M. (1970). Time series analysis: Forecasting and control. Holden-Day.

Hyndman, R. J., & Athanasopoulos, G. (2021). Forecasting: Principles and practice (3rd ed.). OTexts. \cr \url{https://otexts.com/fpp3/}

Venables, W. N., & Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth Edition. Springer-Verlag.
}
\author{
Ka Yui Karl Wu
}
