% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_channel_activities.R
\name{list_channel_activities}
\alias{list_channel_activities}
\title{List Channel Activity}
\usage{
list_channel_activities(channel_id = NULL, part = "snippet",
  max_results = 50, page_token = NULL, published_after = NULL,
  published_before = NULL, region_code = NULL, ...)
}
\arguments{
\item{channel_id}{ID of the channel. Required. No default.}

\item{part}{specify which part do you want. It can only be one of the three: \code{contentDetails, id, snippet}. Default is \code{snippet}.}

\item{max_results}{Maximum number of items that should be returned. Integer. Optional. Can be between 0 and 50. Default is 50.}

\item{page_token}{specific page in the result set that should be returned, optional}

\item{published_after}{Character. Optional. RFC 339 Format. For instance, "1970-01-01T00:00:00Z"}

\item{published_before}{Character. Optional. RFC 339 Format. For instance, "1970-01-01T00:00:00Z"}

\item{region_code}{ISO 3166-1 alpha-2 country code, optional, see also \code{\link{list_regions}}}

\item{\dots}{Additional arguments passed to \code{\link{tuber_GET}}.}
}
\value{
named list
}
\description{
Returns a list of channel events that match the request criteria.
}
\examples{
\dontrun{
list_channel_activities(channel_id="UCRw8bIz2wMLmfgAgWm903cA")
list_channel_activities(channel_id="UCRw8bIz2wMLmfgAgWm903cA", regionCode="US")
}
}
\references{
\url{https://developers.google.com/youtube/v3/docs/activities/list}
}

