% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_loading.R
\name{load_params}
\alias{load_params}
\title{Load Parameters from YAML File}
\usage{
load_params(filepath = NULL)
}
\arguments{
\item{filepath}{Character. Path to the YAML file. If \code{NULL}, the function
will attempt to load the default \code{params.yaml} provided in the package.}
}
\value{
A list containing the parameters loaded from the YAML file.
}
\description{
Reads a YAML file containing model parameters, including station settings,
variables, and configurations for various models. If no file path is
provided, the function defaults to loading \code{params.yaml} from the package's
\code{extdata} directory.
}
\details{
The YAML file should define parameters in a structured format, such as:

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{target: 'NO2'

lightgbm:
  nrounds: 200
  eta: 0.03
  num_leaves: 32

dynamic_regression:
  ntrain: 8760

random_forest:
  num.trees: 300
  max.depth: 10

meteo_variables:
  - GLO
  - TMP
}\if{html}{\out{</div>}}
}
\examples{
params <- load_params()
}
