% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxSummaryGxE}
\alias{umxSummary.MxModel.GxE}
\alias{umxSummaryGxE}
\title{umxSummaryGxE}
\usage{
umxSummaryGxE(model = NULL, digits = 2, xlab = NA, location = "topleft",
  separateGraphs = FALSE, dotFilename = NULL, returnStd = NULL,
  showStd = NULL, reduce = FALSE, CIs = NULL, report = 1, ...)
}
\arguments{
\item{model}{A fitted \code{\link{umxGxE}} model to summarize}

\item{digits}{rounding (default = 2)}

\item{xlab}{label for the x-axis of plot}

\item{location}{default = "topleft"}

\item{separateGraphs}{default = F}

\item{dotFilename}{The name of the dot file to write. Defaults to name of the model. NA = no plot}

\item{returnStd}{Whether to return the standardized form of the model (default = FALSE)}

\item{showStd}{Whether to show the standardized model (not implemented! TRUE)}

\item{reduce}{Whether run and tabulate a complete model reduction...(Defaults to FALSE)}

\item{CIs}{Confidence intervals (FALSE)}

\item{report}{1 = regular, 2 = add descriptive sentences; 3 = open a browser and copyable tables}

\item{...}{Optional additional parameters}
}
\value{
- optional \code{\link{mxModel}}
}
\description{
Summarise a Moderation model, as returned by \code{\link{umxGxE}}
}
\examples{
# The total sample has been subdivided into a young cohort,
# aged 18-30 years, and an older cohort aged 31 and above.
# Cohort 1 Zygosity is coded as follows 1 == MZ females 2 == MZ males
# 3 == DZ females 4 == DZ males 5 == DZ opposite sex pairs
require(OpenMx)
data(twinData)
labList = c("MZFF", "MZMM", "DZFF", "DZMM", "DZOS")
twinData$ZYG = factor(twinData$zyg, levels = 1:5, labels = labList)
twinData$age1 = twinData$age2 = twinData$age
selDVs  = c("bmi1", "bmi2")
selDefs = c("age1", "age2")
selVars = c(selDVs, selDefs)
mzData  = subset(twinData, ZYG == "MZFF", selVars)
dzData  = subset(twinData, ZYG == "DZMM", selVars)
# Exclude cases with missing Def
mzData <- mzData[!is.na(mzData[selDefs[1]]) & !is.na(mzData[selDefs[2]]),]
dzData <- dzData[!is.na(dzData[selDefs[1]]) & !is.na(dzData[selDefs[2]]),]
m1 = umxGxE(selDVs = selDVs, selDefs = selDefs, dzData = dzData, mzData = mzData)
m1 = umxRun(m1)
# Plot Moderation
umxSummaryGxE(m1)
umxSummaryGxE(m1, location = "topright")
umxSummaryGxE(m1, separateGraphs = FALSE)
}
\references{
- \url{https://github.com/tbates/umx}, \url{http://tbates.github.io}
}
\seealso{
- \code{\link{umxGxE}()}, \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, and ACE models.
}

