% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/misc_and_utility.r
\name{umx_is_ordered}
\alias{umx_is_ordered}
\title{umx_is_ordered}
\usage{
umx_is_ordered(df, names = FALSE, strict = TRUE, binary.only = FALSE,
  ordinal.only = FALSE, continuous.only = FALSE)
}
\arguments{
\item{df}{an \code{\link{data.frame}} to look in for ordinal variables}

\item{names}{whether to return the names of ordinal variables, or a binary (T,F) list (default = FALSE)}

\item{strict}{whether to stop when unordered factors are found (default = TRUE)}

\item{binary.only}{only count binary factors (2-levels) (default = FALSE)}

\item{ordinal.only}{only count ordinal factors (3 or more levels) (default = FALSE)}

\item{continuous.only}{use with names = TRUE to get the names of the continuous variables}
}
\value{
- vector of variable names or Booleans
}
\description{
Return the names of any ordinal variables in a dataframe
}
\examples{
tmp = mtcars
tmp$cyl = ordered(mtcars$cyl) # ordered factor
tmp$vs = ordered(mtcars$vs) # binary factor
umx_is_ordered(tmp) # numeric indices
umx_is_ordered(tmp, names = TRUE)
umx_is_ordered(tmp, names = TRUE, binary.only = TRUE)
umx_is_ordered(tmp, names = TRUE, ordinal.only = TRUE)
umx_is_ordered(tmp, names = TRUE, continuous.only = TRUE)
umx_is_ordered(tmp, continuous.only = TRUE)
isContinuous = !umx_is_ordered(tmp)
tmp$gear = factor(mtcars$gear) # unordered factor
# nb: Factors are not necessarily ordered! By default unordered factors cause an message...
\dontrun{
tmp$cyl = factor(mtcars$cyl)
umx_is_ordered(tmp, names=TRUE)
}
}
\references{
- \url{http://www.github.com/tbates/umx}
}
\seealso{
Other Miscellaneous Functions: \code{\link{umxEval}};
  \code{\link{umxJiggle}}; \code{\link{umx_APA_pval}};
  \code{\link{umx_add_variances}}; \code{\link{umx_apply}};
  \code{\link{umx_check_OS}};
  \code{\link{umx_check_model}};
  \code{\link{umx_check_multi_core}};
  \code{\link{umx_checkpoint}},
  \code{\link{umx_set_checkpoint}};
  \code{\link{umx_check}};
  \code{\link{umx_default_option}};
  \code{\link{umx_get_CI_as_APA_string}};
  \code{\link{umx_get_bracket_addresses}};
  \code{\link{umx_get_checkpoint}};
  \code{\link{umx_get_cores}};
  \code{\link{umx_get_optimizer}};
  \code{\link{umx_has_CIs}};
  \code{\link{umx_has_been_run}};
  \code{\link{umx_has_means}};
  \code{\link{umx_has_square_brackets}};
  \code{\link{umx_is_MxMatrix}};
  \code{\link{umx_is_MxModel}}; \code{\link{umx_is_RAM}};
  \code{\link{umx_is_cov}};
  \code{\link{umx_is_endogenous}};
  \code{\link{umx_is_exogenous}};
  \code{\link{umx_object_as_str}};
  \code{\link{umx_reorder}}; \code{\link{umx_set_cores}};
  \code{\link{umx_set_optimizer}};
  \code{\link{umx_standardize_IP}};
  \code{\link{umx_string_to_algebra}}; \code{\link{umx}},
  \code{\link{umx-package}}
}

