% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uni_Freiburg.R
\docType{data}
\name{uni_freiburg_1}
\alias{uni_freiburg_1}
\title{Primary colors of the University of Freiburg, Germany}
\format{
An object of class \code{character} of length 7.
}
\source{
Color definitions are based on the new web style guide at 
\url{https://uni-freiburg.de/} 
(at \code{https://cd.uni-freiburg.de/farben/} on 2023-04-28).
}
\usage{
uni_freiburg_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_freiburg_1} provides a primary color palette 
of the \href{https://uni-freiburg.de/}{University of Freiburg}, Germany.
}
\details{
The primary color \code{blau} (here: \code{uni_freiburg_1[1]}) is alternatively defined as 
\code{Pantone 7687C}, \code{RGB 52/74/154}, \code{HEX #344a9a}, or \code{CMYK 90/75/0/0}.

The color \code{sand} is alternatively defined as \code{HEX #f6f1e3}, \code{RGB 246/241/227}, and \code{CMYK 0/2/10/5}. 

The gradient of \code{blau} colors is defined on \url{https://cd.uni-freiburg.de/farben/}. 

See \code{\link{uni_freiburg_0}} for the basic colors (without the \code{Blau} color gradient) 
and the \code{\link{ac}} and \code{\link{usecol}} functions for creating alternative color gradients.
}
\examples{
uni_freiburg_1
unikn::seecol(uni_freiburg_1, main = "Primary color gradient of the University of Freiburg")
unikn::demopal(uni_freiburg_1, type = 1, main = "Primary color gradient of Freiburg University")

# Get a "sand" color gradient:
sand_gradient <- unikn::usecol(c(uni_freiburg_1["sand"], "white"), n = 3)[1:3] 
# demopal(sand_gradient)

}
\seealso{
\code{\link{uni_freiburg_0}} for the basic colors of the University of Freiburg;
\code{\link{uni_freiburg_2}} for the secondary colors of the University of Freiburg;
\code{\link{seecol}} for viewing and comparing color palettes; 
\code{\link{usecol}} for using color palettes; 
\code{\link{simcol}} for finding similar colors; 
\code{\link{newpal}} for defining new color palettes; 
\code{\link{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0}},
\code{\link{fu_1}},
\code{\link{fu_2}},
\code{\link{fu_3}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2023-04-28.
}
\concept{German university color palettes}
\keyword{datasets}
