% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.spear}
\alias{se.spear}
\title{Computes the standard error for a Spearman correlation}
\usage{
se.spear(cor, n)
}
\arguments{
\item{cor}{estimated Spearman correlation}

\item{n}{sample size}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - Spearman correlation (from input)
\item SE - standard error
}
}
\description{
This function computes the Bonett-Wright standard
error of a Spearman correlation using the estimated correlation
and sample size. The standard error from this function can be used
as input in the \link[vcmeta]{meta.ave.cor.gen} function in applications
where a combination of different types of correlations are used in
the meta-analysis.
}
\examples{
se.spear(.40, 55)

# Should return: 
#                       Estimate        SE
# Spearman correlation:      0.4 0.1210569


}
\references{
\insertRef{Bonett2000}{vcmeta}
}
