% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_order.R
\name{emis_order}
\alias{emis_order}
\alias{weekly}
\title{Re-order the emission to match specific hours and days}
\format{Emissions}
\usage{
emis_order(EMISSION, start = "mon", hours = 168, verbose = FALSE)
}
\arguments{
\item{EMISSION}{GriddedEmissionsArray or array with characteristics of
GriddedEmissionsArray}

\item{start}{Date or the start weekday or first 3 letters}

\item{hours}{Numeric; number of hours needed to the simualation}

\item{verbose}{Logical; display additional information}
}
\description{
returns the emission array matching with corresponding weekdays and with
the desired number of hours, recycling or droping hours from the emission array.
}
\note{
This function assumes that the emissions have hours with length of
factor of 24, e.g: 24 hours, 24*2 hours etc. Then, it re-order the emissions
by the hours of estimations to match another length of emissions. For
instance, if the input covers 168 hours and it is desired an object of 241
hours that start saturday, this function can do that. It is useful when you
are going to start a air quality simulation for specific periods of time.
}
\examples{
\dontrun{
wCO <- weekly(CO, start = "sat", hours = 24, verbose = TRUE)
wCO <- weekly(CO, start = as.Date("2016-04-06"), hours = 241, verbose = TRUE)
}

}
\author{
Daniel Schuch
}
