\name{semipar.mix.mp}
\alias{semipar.mix.mp}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Massively parallel semiparametric mixed models
}
\description{
Fits a set of semiparametric mixed models, with a common design matrix, by repeated calls to \code{\link[gamm4]{gamm4}}. Only a single smooth term is permitted.
}
\usage{
semipar.mix.mp(Y, x, param = NULL, random, data.ran, k = 10, norder = 4, 
               pen.order = 2, knots = "quantile", store.gamm4 = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{Y}{
\eqn{n \times V} response matrix.
}
  \item{x}{
a vector giving the predictor upon which each column of \code{Y} is regressed.
}
  \item{param}{
a matrix or vector for the parametric terms in the model. 
}
  \item{random}{
a formula, passed to \code{\link[gamm4]{gamm4}}, specifying the random effects structure in \code{\link[lme4]{lmer}} style. See the example.
}
  \item{data.ran}{
a required data frame containing the factors used for random effects.  
}
  \item{k}{
number of knots.
}
  \item{norder}{
order of B-splines: the default, \code{4}, gives cubic B-splines.
}
  \item{pen.order}{
order of the derivative penalty.
}
  \item{knots}{
knot placement for the B-spline bases. The default,
\code{"quantile"}, gives knots at equally spaced quantiles of the data.
The alternative, \code{"equispaced"}, gives equally spaced knots.
}
  \item{store.gamm4}{
logical: should the \code{\link[gamm4]{gamm4}} objects to be stored in the output? \code{FALSE} by default.
}
}

\details{
	Unlike \code{\link{semipar.mp}}, this function does not use large matrix multiplications to avoid looping through model fits. Instead it performs a separate call to \code{\link[gamm4]{gamm4}} to fit a semiparametric mixed model for each column of \code{Y}.
}
\value{
\item{coef}{matrix of the coefficients obtained from \code{\link[gamm4]{gamm4}} looping (including both parametric and nonparametric parts).}
\item{bsplinecoef}{matrix of B-spline coefficients.}
\item{pwdf}{vector of pointwise effective degrees of freedom.}
\item{pwlsp}{vector of pointwise log smoothing parameters: grid values maximizing the restricted likelihood at each point.}
\item{B}{matrix of basis function values.}
\item{C}{the constraint matrix.}
\item{Z}{transformation matrix to impose constraints.}
\item{basis}{B-spline basis object, of the type created by the \pkg{fda} package; the coefficient estimates are with respect to this basis.}
}
\author{
Yin-Hsiu Chen \email{enjoychen0701@gmail.com} and
Philip Reiss \email{phil.reiss@nyumc.org}
}

\examples{
Y = matrix(rnorm(3000),,3)
x1 = rnorm(1000)
x2 = matrix(rnorm(2000),,2)
family.fac <- factor(rep(1:20,rep(50,20)))
person.fac <- factor(rep(rep(1:25,rep(2,25)),rep(20,50)))
semimix = semipar.mix.mp(Y = Y, x = x1, param = x2, random = ~ (1|a/b), 
          data.ran = data.frame(a = family.fac, b = person.fac))
}
