% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hostess.R
\name{hostessLoader}
\alias{hostessLoader}
\alias{hostess_loader}
\alias{hostess_gradient}
\alias{hostess_bubble}
\alias{hostess_stripe}
\title{Loader}
\usage{
hostess_loader(
  id = "hostess",
  preset = NULL,
  text_color = "#FFFFFF",
  center_page = FALSE,
  class = "",
  min = 0,
  max = 100,
  svg = NULL,
  progress_type = c("stroke", "fill"),
  fill_direction = c("btt", "ttb", "ltr", "rtl"),
  stroke_direction = c("normal", "reverse"),
  fill_color = NULL,
  stroke_color = NULL,
  ...
)

hostess_gradient(angle = 0, duration = 1, colors = c("red", "white", "blue"))

hostess_bubble(
  color_background = "#697682",
  color_bubble = "#f7fff7",
  count = 25,
  duration = 1
)

hostess_stripe(color1 = "#697682", color2 = "#f7fff7", duration = 1)
}
\arguments{
\item{id}{Id of hostess (valid CSS).}

\item{preset}{A loading bar preset, see section below.}

\item{text_color}{The color of the loading text.}

\item{center_page}{By default the hostess is \emph{not} centered in the middle
of the screen, centering in the middle of the page is however ideal when using
it with waiter full screen, for the latter set to \code{TRUE}.}

\item{class}{CSS class.}

\item{min, max}{Minimum and maximum representing the starting and ending
points of the progress bar.}

\item{svg}{Either an svg path e.g.: \code{M10 10L90 10} or the path to a \code{.svg}
file. Note that if passing the latter it must be made available to Shiny by
placing it either in the \code{www} folder or using \code{\link[shiny:resourcePaths]{shiny::addResourcePath()}}.}

\item{progress_type}{The progress type, either \code{stroke} or \code{fill}.
Ther former traces the path of the \code{svg} while the latter fills it progressively.}

\item{fill_direction, stroke_direction}{The direction which the progress bar should
take. Wether \code{fill_direction} or \code{stroke_direction} is used depends on
\code{progress_type}.}

\item{fill_color, stroke_color}{The color to use for the progress bar.
Wether \code{fill_color} or \code{stroke_color} is used depends on
\code{progress_type}.}

\item{...}{Any other other advanced options to pass to the loaded
see the \href{https://loading.io/progress/}{official documentation}.}

\item{angle}{Angle of gradient.}

\item{duration}{Duration of the loop.}

\item{colors}{Color vectors composing the gradient.}

\item{color_background}{The background of the color.}

\item{color_bubble}{The color of the bubbles contour.}

\item{count}{The number of bubbles.}

\item{color1, color2}{Colors of stripes.}
}
\description{
Customise the Hostess laoding bar.
}
\section{Presets}{

\itemize{
\item{\code{line}}
\item{\code{fan}}
\item{\code{circle}}
\item{\code{bubble}}
\item{\code{rainbow}}
\item{\code{energy}}
\item{\code{stripe}}
\item{\code{text}}
}
}

\examples{
library(shiny)
library(waiter)

# diagonal line
path <- "M10 10L90 30"

ui <- fluidPage(
 use_waiter(),
 use_hostess(),
 actionButton("draw", "redraw"),
 plotOutput("plot")
)

server <- function(input, output) {

 dataset <- reactive({
   input$draw

   hostess <- Hostess$new(min = 0, max = 10)
   hostess$set_loader <- hostess_loader(
     progress_type = "stroke",
     stroke_color = hostess_stripe()
   )
   waiter <- Waiter$new(
     "plot", 
     hostess$loader()
   )

   waiter$show()

   for(i in 1:10){
     Sys.sleep(.2)
     hostess$inc(1)
   }

   runif(100)

 })

output$plot <- renderPlot(plot(dataset()))

}

if(interactive()) shinyApp(ui, server)

}
