% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_forecast_towns.R
\name{find_forecast_towns}
\alias{find_forecast_towns}
\title{Find the Nearest Town With a BOM Forecast}
\usage{
find_forecast_towns(longitude = 149.2, latitude = -35.3, distance_km = 100)
}
\arguments{
\item{longitude}{A \code{numeric} value of longitude in decimal degree (DD)
format.  By default, Canberra (approximately).}

\item{latitude}{A \code{numeric} value of latitude in decimal degree (DD)
format.  By default, Canberra (approximately).}

\item{distance_km}{A \code{numeric} value of the distance in kilometres from the
\code{latitude} and \code{longitude} point beyond which values will not be returned.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} of all forecast towns (in this package) sorted by
distance from \var{latitude} and \var{longitude}, ascending.
}
\description{
For a given \code{latitude} and \code{longitude}, find the nearest town that the
\acronym{BOM} provides a forecast for.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# find forecast towns near Esperance, WA
find_forecast_towns(longitude = 121.8913, latitude = -33.8614)
\dontshow{\}) # examplesIf}
}
\seealso{
Other BOM: 
\code{\link{get_ag_bulletin}()},
\code{\link{get_available_imagery}()},
\code{\link{get_available_radar}()},
\code{\link{get_coastal_forecast}()},
\code{\link{get_precis_forecast}()},
\code{\link{get_radar_imagery}()},
\code{\link{get_satellite_imagery}()},
\code{\link{parse_ag_bulletin}()},
\code{\link{parse_coastal_forecast}()},
\code{\link{parse_precis_forecast}()}

Other metadata: 
\code{\link{find_nearby_stations}()},
\code{\link{find_stations_in}()},
\code{\link{get_available_imagery}()},
\code{\link{get_available_radar}()},
\code{\link{get_dpird_availability}()},
\code{\link{get_stations_metadata}()}
}
\author{
Hugh Parsonage, \email{hugh.parsonage@gmail.com}, and James Goldie,
\email{me@jamesgoldie.dev}, and Adam H. Sparks,
\email{adamhsparks@gmail.com}
}
\concept{BOM}
\concept{metadata}
