% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{stations}
\alias{stations}
\title{Station data downloaded from Environment and Climate Change Canada}
\format{A data frame with 26211 rows and 12 variables:
\describe{
  \item{prov}{Province}
  \item{station_name}{Station name}
  \item{station_id}{Environment Canada's station ID number. Required for
  downloading station data.}
  \item{climate_id}{Climate ID number}
  \item{WMO_id}{Climate ID number}
  \item{TC_id}{Climate ID number}
  \item{lat}{Latitude of station location in degree decimal format}
  \item{lon}{Longitude of station location in degree decimal format}
  \item{elev}{Elevation of station location in metres}
  \item{interval}{Interval of the data measurements ('hour', 'day', 'month')}
  \item{start}{Starting year of data record}
  \item{end}{Ending year of data record}
}}
\source{
\url{http://climate.weather.gc.ca/index_e.html}
}
\usage{
stations
}
\description{
A dataset containing station information downloaded from Environment and
Climate Change Canada. Note that a station may have several station IDs,
depending on how the data collection has changed over the years. Station
information can be updated by running \code{stations_new <-  stations_dl()}
and then by specifying stn = stations_new in most functions.
}
\keyword{datasets}
