% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code_names.R
\name{add_item_cbs_name}
\alias{add_item_cbs_name}
\title{Get commodity balance sheet item names from item codes}
\usage{
add_item_cbs_name(
  table,
  code_column = "item_cbs_code",
  name_column = "item_cbs_name"
)
}
\arguments{
\item{table}{The table that will be modified with a new column.}

\item{code_column}{The name of the column in \code{table} containing the codes.}

\item{name_column}{The name of the output column containing the names.}
}
\value{
A tibble with all the contents of \code{table} and an extra column
named \code{name_column}, which contains the names. If there is no name match,
an \code{NA} is included.
}
\description{
Add a new column to an existing tibble with the corresponding name
for each commodity balance sheet item code. The codes are assumed to be
from those defined by FAOSTAT.
}
\examples{
table <- tibble::tibble(item_cbs_code = c(2559, 2744, 9876))
add_item_cbs_name(table)

table |>
  dplyr::rename(my_item_cbs_code = item_cbs_code) |>
  add_item_cbs_name(code_column = "my_item_cbs_code")

add_item_cbs_name(table, name_column = "my_custom_name")
}
