% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow.R
\name{is_trained_workflow}
\alias{is_trained_workflow}
\title{Determine if a workflow has been trained}
\usage{
is_trained_workflow(x)
}
\arguments{
\item{x}{A workflow.}
}
\value{
A single logical indicating if the workflow has been trained or not.
}
\description{
A trained workflow is one that has gone through \code{\link[=fit.workflow]{fit()}},
which preprocesses the underlying data, and fits the parsnip model.
}
\examples{
\dontshow{if (rlang::is_installed("recipes")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(parsnip)
library(recipes)
library(magrittr)

rec <- recipe(mpg ~ cyl, mtcars)

mod <- linear_reg()
mod <- set_engine(mod, "lm")

wf <- workflow() \%>\%
  add_recipe(rec) \%>\%
  add_model(mod)

# Before any preprocessing or model fitting has been done
is_trained_workflow(wf)

wf <- fit(wf, mtcars)

# After all preprocessing and model fitting
is_trained_workflow(wf)
\dontshow{\}) # examplesIf}
}
