% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flag_extreme.R
\name{flag_extreme}
\alias{flag_extreme}
\title{Warn for extreme values by checking against a threshold}
\usage{
flag_extreme(
  data,
  metric,
  person = TRUE,
  threshold,
  mode = "above",
  return = "message"
)
}
\arguments{
\item{data}{A Standard Person Query dataset in the form of a data frame.}

\item{metric}{A character string specifying the metric to test.}

\item{person}{A logical value to specify whether to calculate
person-averages. Defaults to \code{TRUE} (person-averages calculated).}

\item{threshold}{Numeric value specifying the threshold for flagging.}

\item{mode}{String determining mode to use for identifying extreme values.
\itemize{
\item \code{"above"}: checks whether value is great than the threshold (default)
\item \code{"equal"}: checks whether value is equal to the threshold
\item \code{"below"}: checks whether value is below the threshold
}}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"text"}
\item \code{"message"}
\item \code{"table"}
}

See \code{Value} for more information.}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"text"}: string. A diagnostic message.
\item \code{"message"}: message on console. A diagnostic message.
\item \code{"table"}: data frame. A person-level table with \code{PersonId} and the
extreme values of the selected metric.
}
}
\description{
This is used as part of data validation to check if there are extreme values
in the dataset.
}
\examples{
# The threshold values are intentionally set low to trigger messages.
flag_extreme(sq_data, "Email_hours", threshold = 15)

# Return a summary table
flag_extreme(sq_data, "Email_hours", threshold = 15, return = "table")

# Person-week level
flag_extreme(sq_data, "Email_hours", person = FALSE, threshold = 15)

# Check for values equal to threshold
flag_extreme(sq_data, "Email_hours", person = TRUE, mode = "equal", threshold = 0)

# Check for values below threshold
flag_extreme(sq_data, "Email_hours", person = TRUE, mode = "below", threshold = 5)


}
\seealso{
Other Data Validation: 
\code{\link{check_query}()},
\code{\link{extract_hr}()},
\code{\link{flag_ch_ratio}()},
\code{\link{flag_em_ratio}()},
\code{\link{flag_outlooktime}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count}()},
\code{\link{hrvar_count_all}()},
\code{\link{hrvar_trend}()},
\code{\link{identify_churn}()},
\code{\link{identify_holidayweeks}()},
\code{\link{identify_inactiveweeks}()},
\code{\link{identify_nkw}()},
\code{\link{identify_outlier}()},
\code{\link{identify_privacythreshold}()},
\code{\link{identify_query}()},
\code{\link{identify_shifts}()},
\code{\link{identify_shifts_wp}()},
\code{\link{identify_tenure}()},
\code{\link{remove_outliers}()},
\code{\link{standardise_pq}()},
\code{\link{subject_validate}()},
\code{\link{subject_validate_report}()},
\code{\link{track_HR_change}()},
\code{\link{validation_report}()}
}
\concept{Data Validation}
