% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anlz_perchg.R
\name{anlz_perchg}
\alias{anlz_perchg}
\title{Estimate percent change trends from GAM results for selected time periods}
\usage{
anlz_perchg(mod, baseyr, testyr)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{baseyr}{numeric vector of starting years}

\item{testyr}{numeric vector of ending years}
}
\value{
A data frame of summary results for change between the years.
}
\description{
Estimate percent change trends from GAM results for selected time periods
}
\details{
Working components of this function were taken from the gamDiff function in the baytrends package.
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl')
  
mod <- anlz_gam(tomod, trans = 'log10')
anlz_perchg(mod, baseyr = 1990, testyr = 2016)
}
\concept{analyze}
