% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaRerun.R
\name{xegaReRun}
\alias{xegaReRun}
\title{Run an evolutionary or genetic algorithm 
with the same configuration as in the previous run.}
\usage{
xegaReRun(solution, script = FALSE, fn = "xegaRunScript")
}
\arguments{
\item{solution}{The solution of a 
previous run of \code{xegaRun()}.}

\item{script}{Boolean. Default: FALSE. 
If TRUE, write an R script to repeat the xega run
with the command in the solution object.}

\item{fn}{Filename of R script. Default: xegaRunScript.R}
}
\value{
A list of 
        \enumerate{
        \item
        \code{$popStat}: A matrix with 
                        mean, min, Q1, median, Q3, max, var, mad
                         of population fitness as columns:
                         i-th row for i-th each generation.
        \item 
        \code{$fit}: Fitness vector if \code{generations<=1} else: NULL.
        \item
        \code{$solution}: With fields 
        \code{$solution$name},
        \code{$solution$fitness}, 
        \code{$solution$value},  
        \code{$numberOfSolutions},
        \code{$solution$genotype}, 
        \code{$solution$phenotype}, 
        \code{$solution$phenotypeValue}, 
        \item 
        \code{$evalFail}: Number of failures of fitness evaluations.
        \item
        \code{$GAconfig}: The configuration of the GA used by \code{xegaReRun()}.
        \item
        \code{$GAenv}:  Attribute value list of GAconfig.
        \item \code{$timer}: An attribute value list with 
              the time used (in seconds) in the main blocks of the GA:
              tUsed, tInit, tNext, tEval, tObserve, and tSummary.
        }
}
\description{
\code{xegaReRun()} runs a simple genetic algorithm with 
             the same configuration as in the run specified by the 
             list element \code{$GAconfig} of the solution of 
             a simple genetic algorithm. The problem environment and the 
             the grammar are extracted from the solution object.

             If \code{script==TRUE}, the \code{solution} object and a R script 
             to rerun xega are written to the current directory.
}
\details{
\code{xegaReRun()} does not capture the configuration for 
         parallel/distributed processing for the execution model
         "FutureApply", because the user defines the configuration
         before calling \code{xegaRun()}. 

         If \code{executionModel} matches neither \code{"Sequential"} nor \code{"MultiCore"}
         or \code{!is.null(uParApply)==TRUE},   
         a warning is printed, and the previous solution is returned.
}
\examples{
a<-xegaRun(Parabola2D, max=FALSE, algorithm="sga", generations=10, popsize=20, verbose=1)
b<-xegaReRun(a)
seqApply<-function(pop, EvalGene, lF) {lapply(pop, EvalGene, lF)}
c<-xegaRun(Parabola2D, max=FALSE, algorithm="sga", uParApply=seqApply)
b<-xegaReRun(c)

}
\seealso{
Other Main Program: 
\code{\link{xegaRun}()}
}
\concept{Main Program}
