% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ycevo.R, R/estimation.R
\name{ycevo}
\alias{ycevo}
\alias{estimate_yield}
\title{Estimate yield function}
\usage{
ycevo(
  data,
  x,
  span_x = 60,
  hx = NULL,
  tau = NULL,
  ht = NULL,
  tau_p = tau,
  htp = NULL,
  cols = NULL,
  ...
)

estimate_yield(
  data,
  xgrid,
  hx,
  tau,
  ht,
  tau_p = tau,
  htp = ht,
  rgrid = NULL,
  hr = NULL,
  interest = NULL,
  cfp_slist = NULL
)
}
\arguments{
\item{data}{Data frame; bond data to estimate discount curve from. See
\code{\link[=ycevo_data]{ycevo_data()}} for an example bond data structure. Minimum required columns
are \code{qdate}, \code{id}, \code{price}, \code{tupq}, and \code{pdint}. The columns can be named
differently: see \code{cols}.}

\item{x}{Time grids at which the discount curve is evaluated. Should be
specified using the same class of object as the quotation date (\code{qdate})
column in \code{data}.}

\item{span_x}{Half of the window size, or the distance from the centre \code{x} to
the maximum (or the minimum) \code{qdate} with non-zero weight using the kernel
function, measured by the number of regular interval between two
consecutive \code{qdate}. Ignored if \code{hx} is specified. See \code{Details}.}

\item{hx}{Numeric vector. Bandwidth parameters corresponding to each time
point \code{x}.}

\item{tau}{Numeric vector. Time-to-maturities in years where
discount function and yield curve will be estimated for each of time points \code{x}.
See \code{Details}.}

\item{ht}{Numeric vector. Bandwidth parameters corresponding to each value of
time-to-maturities \code{tau}. See \code{Details}.}

\item{tau_p}{Numeric vector. Auxiliary time-to-maturities in
years. See \code{Details}.}

\item{htp}{Numeric vector. Bandwidth parameters corresponding to each of
auxiliary time-to-maturities \code{tau_p}. See \code{Details}.}

\item{cols}{<\code{\link[=dplyr_tidy_select]{tidy-select}}> A named list or vector of
alternative names of required variables, following the \code{new_name = old_name} syntax of the \code{\link[dplyr:rename]{dplyr::rename()}}, where the \code{new_nam} takes one of
the five column names required in \code{data}. This enables the user to provide
\code{data} with columns named differently from required.}

\item{...}{Specification of an additional covariate, taking the form of \code{var = list(grid, bandwidth)}, where \code{var} is the name of the covariate in
\code{data}, \code{grid} is the values at which the yield curve is estimated,
similar to \code{x}, and \code{bandwidth} is the bandwidth parameter corresponding to
each of the \code{grid} values, similar to \code{hx}.}

\item{xgrid}{Numeric vector. Values between 0 and 1. Time grids over the
entire time horizon (percentile) of the data at which the discount function is
evaluated.}

\item{rgrid}{(Optional) Numeric vector. Interest rate grids in percentage
at which the discount function is evaluated, e.g. 4.03 means at interest rate
of 4.03\%.}

\item{hr}{(Optional) Numeric vector. Bandwidth parameter in percentage
determining the size of the window in the kernel function that corresponds
to each interest rate grid (`rgrid`).}

\item{interest}{(Optional) Numeric vector. Daily short term interest rates.
The length is the same as the number of quotation dates included in the
data, i.e. one interest rate per day.}

\item{cfp_slist}{(Internal) Experienced users only. A list of matrices,
generated by the internal function `get_cfp_slist`.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} object of class \code{ycevo} with the following
columns.

\describe{
\item{qdate}{The time points that user-specified as \code{x}. The name of this
column will be consistent with the name of the time index column in the
\code{data} input, if the user choose to provide a data frame with the time
index column named differently from \code{qdate} with the \code{cols} argument.}
\item{.est}{A nested columns of estimation results containing a
\code{\link[tibble:tibble]{tibble::tibble()}} for each \code{qdate}. Each \code{tibble} contains three columns:
\code{tau} for the time-to-maturity specified by the user in the \code{tau} argument,
\code{.disount} for the estimated discount function at this time and this
time-to-maturity, and \code{.yield} for the estimated yield curve.}
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Nonparametric estimation of discount functions and yield curves at given
dates, time-to-maturities, and one additional covariate, usually interest
rate.
}
\details{
Suppose that a bond \eqn{i} has a price \eqn{p_i} at time \eqn{t} with a
set of cash payments, say \eqn{c_1, c_2, \ldots, c_m} with a set of
corresponding discount values \eqn{d_1, d_2, \ldots, d_m}. In the bond
pricing literature, the market price of a bond should reflect the
discounted value of cash payments. Thus, we want to minimise
\deqn{(p_i-\sum^m_{j=1}c_j\times d_j)^2.} For the estimation of \eqn{d_k(k=1,
\ldots, m)}, solving the first order condition yields
\deqn{(p_i-\sum^m_{j=1}c_j \times d_j)c_k = 0, } and \deqn{\hat{d}_k =
\frac{p_i c_k}{c_k^2} - \frac{\sum^m_{j=1,k\neq k}c_k c_j d_j}{c_k^2}.}

There are challenges: \eqn{\hat{d}_k} depends on all the relevant discount
values for the cash payments of the bond. Our model contains random errors
and our interest lies in expected value of \eqn{d(.)} where the expected
value of errors is zero. \eqn{d(.)} is an infinite-dimensional function not
a discrete finite-dimensional vector. Generally, cash payments are made
biannually, not dense at all. Moreover, cash payment schedules vary over
different bonds.

Let \eqn{d(\tau, X_t)} be the discount function at given covariates
\eqn{X_t} (dates \code{x} and interest rates \code{rgrid}), and given
time-to-maturities \eqn{\tau} (\code{tau}). \eqn{y(\tau, X_t)} is the yield
curve at given covariates \eqn{X_t} (dates \code{x} and interest rates
\code{rgrid}), and given time-to-maturities \eqn{\tau} (\code{tau}).

We pursue the minimum of the following smoothed sample least squares
objective function for any smooth function \eqn{d(.)}: \deqn{Q(d) =
\sum^T_{t=1}\sum^n_{i=1}\int\{p_{it}-\sum^{m_{it}}_{j=1}c_{it}(\tau_{ij})d(s_{ij},
x)\}^2 \sum^{m_{it}}_{k=1}\{K_h(s_{ik}-\tau_{ik})ds_{ik}\}K_h(x-X_t)dx,}
where a bond \eqn{i} has a price \eqn{p_i} at time \eqn{t} with a set of cash
payments \eqn{c_1, c_2, \ldots, c_m} with a set of corresponding discount
values \eqn{d_1, d_2, \ldots, d_m}, \eqn{K_h(.) = K(./h)} is the kernel
function with a bandwidth parameter \eqn{h}, the first kernel function is
the kernel in space with bonds whose maturities \eqn{s_{ik}} are close to
the sequence \eqn{\tau_{ik}}, the second kernel function is the kernel in
time and in interest rates with \eqn{x}, which are close to the sequence
\eqn{X_t}. This means that bonds with similar cash flows, and traded in
contiguous days, where the short term interest rates in the market are
similar, are combined for the estimation of the discount function at a
point in space, in time, and in "interest rates".

The estimator for the discount function over time to maturity and time is
\deqn{\hat{d}=\arg\min_d Q(d).} This function provides a data frame of the
estimated yield and discount rate at each combination of the provided
grids. The estimated yield is transformed from the estimated discount rate.

An alternative specification of bandwidth \code{hx} is \code{span_x}, which provides
kernel coverage invariant to the length of \code{data}. \code{span_x} takes an
absolute measure of time depending on the unit of \code{x}. The default value is
60. If the data is daily on trading days, i.e., the interval between every
two consecutive \code{qdate} is one trading day, then the window of the kernel
function allows the estimation at each point \code{x} to contain information
from 60 trading days prior to and after the time point \code{x}.

For more information on the estimation method, please refer to
\code{References}.
}
\section{Functions}{
\itemize{
\item \code{estimate_yield()}: Experienced users only. Yield estimation with interest rate
  and manually selected bandwidth parameters.
  Only length one x and length one hx are supported at a time.
  Returns a data frame of the yield and discount rate at each combination of
  the provided grids.
\describe{
  \item{discount}{Estimated discount rate}
  \item{xgrid}{Same as input `xgrid`}
  \item{tau}{Same as input `tau`}
  \item{yield}{Estimated yield}
}

}}
\examples{
# Simulating bond data
bonds <- ycevo_data(n = 10)
\donttest{
# Estimation can take up to 30 seconds
ycevo(bonds, x = lubridate::ymd("2023-03-01"))
}

}
\references{
Koo, B., La Vecchia, D., & Linton, O. (2021). Estimation of a
nonparametric model for bond prices from cross-section and time series
information. Journal of Econometrics, 220(2), 562-588.
}
\seealso{
\code{\link[=augment.ycevo]{augment.ycevo()}}, \code{\link[=autoplot.ycevo]{autoplot.ycevo()}}
}
