% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workbench_icon.r
\name{read.AmigaIcon}
\alias{read.AmigaIcon}
\title{Read an Amiga Workbench icon (info) file}
\usage{
read.AmigaIcon(file, ...)
}
\arguments{
\item{file}{A \code{character} string representing the file name from which the
icon data should be read.}

\item{...}{Arguments passed on to \code{\link[=rawToAmigaIcon]{rawToAmigaIcon()}}.}
}
\value{
Returns an \code{\link[=AmigaIcon]{AmigaIcon()}} class object as read from the \code{file}.
}
\description{
Graphical representation of files and directories (icons) are stored as
separate files (with the .info extension) on the Amiga. This function reads such files
and imports them as \code{\link[=AmigaIcon]{AmigaIcon()}} class objects.
}
\details{
The \code{\link[=AmigaIcon]{AmigaIcon()}} S3 object provides a comprehensive format
for Amiga icons, which are used as a graphical representation of files
and directories on the Amiga. The \code{\link[=AmigaIcon]{AmigaIcon()}} is a named
list containing all information of an icon. Use this function to
read an Amiga icon (with the .info extension) from a file and convert
it into an \code{\link[=AmigaIcon]{AmigaIcon()}} object.
}
\examples{
## create a simple AmigaIcon:
icon <- simpleAmigaIcon()

## write the icon to the temp dir:
write.AmigaIcon(icon, file.path(tempdir(), "icon.info"))

## read the same file:
icon2 <- read.AmigaIcon(file.path(tempdir(), "icon.info"))
}
\seealso{
Other AmigaIcon.operations: 
\code{\link{AmigaIcon}},
\code{\link{rawToAmigaIcon}()},
\code{\link{simpleAmigaIcon}()},
\code{\link{write.AmigaIcon}()}

Other io.operations: 
\code{\link{read.AmigaBasic}()},
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{read.AmigaBasicShape}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{read.AmigaBitmapFontSet}()},
\code{\link{read.SysConfig}()},
\code{\link{read.iff}()},
\code{\link{write.AmigaBasic}()},
\code{\link{write.AmigaBasicShape}()},
\code{\link{write.AmigaBitmapFont}()},
\code{\link{write.AmigaIcon}()},
\code{\link{write.SysConfig}()},
\code{\link{write.iff}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaIcon.operations}
\concept{io.operations}
