% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allen-mcmc.R
\name{allen_analyze}
\alias{allen_analyze}
\title{Analyze Composite Allen Relations}
\usage{
allen_analyze(x, y, ...)
}
\arguments{
\item{x, y}{A \code{\link{character}} string denoting an Allen relation.}

\item{...}{Further arguments to be passed to internal methods.}
}
\value{
\code{allen_analyze()} is called it for its side-effects: it results in a
graphic being displayed.
}
\description{
Visualize composite Allen relations with a Nokel lattice.
}
\examples{
allen_analyze("mDFo", "MdfO", main = "Composite reticulation relation")
}
\seealso{
Other Allen's intervals: 
\code{\link{allen_analyze_relations}()},
\code{\link{allen_complement}()},
\code{\link{allen_composition}()},
\code{\link{allen_converse}()},
\code{\link{allen_illustrate}()},
\code{\link{allen_illustrate_relations}()},
\code{\link{allen_intersect}()},
\code{\link{allen_joint_concurrency}()},
\code{\link{allen_observe}()},
\code{\link{allen_observe_frequency}()},
\code{\link{allen_plot}()},
\code{\link{allen_relation}()},
\code{\link{allen_relation_code}()},
\code{\link{allen_union}()}
}
\author{
T. S. Dye
}
\concept{Allen's intervals}
