% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onlyDeconAlgorithms.R
\name{collapseCellTypes}
\alias{collapseCellTypes}
\title{Collapse cell yypes}
\usage{
collapseCellTypes(cellCounts, method = "Pheno4")
}
\arguments{
\item{cellCounts}{A matrix with cell counts}

\item{method}{The method for combining cell types ('Default: 'Pheno2')
Pheno1: Original cell-type based combinations
Pheno2: Original cell-type based combinations, omitting Macrophages
Pheno3: Alt Phenotype definitions based on WMB deconvolution correlations
Pheno4: Consensus cell types
Pheno5: Consensus cell types, combined myeloma & plasma
Spillover1: Empirical combinations based on compToLM22source
Spillover2: More agressive combination based on empirical combinations based on compToLM22source
Spillover3: Combinations determined by spillToConvergence on 36 cell types}
}
\value{
a cell estimate matrix with the names changed
}
\description{
Collapse the cell types (in rows) to super-classes
Including MGSM36 cell types
}
\examples{
#This toy example 
library(ADAPTS)
fullLM22 <- ADAPTS::LM22[1:30, 1:4]
smallLM22 <- fullLM22[1:25,] 

cellEst <- estCellPercent.DCQ(refExpr=smallLM22, geneExpr=fullLM22)
collapseCounts <- collapseCellTypes(cellCounts=cellEst)
}
