% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onlyDeconAlgorithms.R
\name{estCellCounts.nPass}
\alias{estCellCounts.nPass}
\title{Deconvolve with an n-pass spillover matrix}
\usage{
estCellCounts.nPass(geneExpr, deconMatrices, method = "DCQ")
}
\arguments{
\item{geneExpr}{The gene expression matrix}

\item{deconMatrices}{The results from spillToConvergence()}

\item{method}{One of 'DCQ', 'SVMDECON', 'DeconRNASeq', 'proportionsInAdmixture', 'nnls' (DEFAULT: DCQ)}
}
\value{
An estimate of cell counts
}
\description{
curExpr <- estCellCounts.nPass(sigMatrix, deconMatrices)
}
\examples{
#This toy example 
library(ADAPTS)
fullLM22 <- ADAPTS::LM22[1:30, 1:4]
smallLM22 <- fullLM22[1:25,] 

deconMatrices <- spillToConvergence(sigMatrix=smallLM22, geneExpr=fullLM22, nPasses=10)
cellCounts <- estCellCounts.nPass(geneExpr=fullLM22, deconMatrices=deconMatrices, method='DCQ')
}
