% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{CV_RIDGEc}
\alias{CV_RIDGEc}
\title{CV ridge penalized precision matrix estimation (c++)}
\usage{
CV_RIDGEc(X, S, lam, path = FALSE, K = 3L, trace = "none")
}
\arguments{
\item{X}{option to provide a nxp matrix. Each row corresponds to a single observation and each column contains n observations of a single feature/variable.}

\item{S}{option to provide a pxp sample covariance matrix (denominator n). If argument is \code{NULL} and \code{X} is provided instead then \code{S} will be computed automatically.}

\item{lam}{positive tuning parameters for ridge penalty. If a vector of parameters is provided, they should be in increasing order. Defaults to grid of values \code{10^seq(-5, 5, 0.5)}.}

\item{path}{option to return the regularization path. This option should be used with extreme care if the dimension is large. If set to TRUE, cores will be set to 1 and errors and optimal tuning parameters will based on the full sample. Defaults to FALSE.}

\item{K}{specify the number of folds for cross validation.}

\item{trace}{option to display progress of CV. Choose one of \code{progress} to print a progress bar, \code{print} to print completed tuning parameters, or \code{none}.}
}
\value{
list of returns includes:
\item{lam}{optimal tuning parameter.}
\item{path}{array containing the solution path. Solutions are ordered dense to sparse.}
\item{min.error}{minimum average cross validation error for optimal parameters.}
\item{avg.error}{average cross validation error across all folds.}
\item{cv.error}{cross validation errors (negative validation likelihood).}
}
\description{
Cross validation function for RIDGEsigma.
}
\keyword{internal}
