% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich.R
\name{enrich}
\alias{enrich}
\title{Perform Adverse Event Enrichment Tests}
\usage{
enrich(
  df,
  dd.group,
  drug.case,
  drug.control = NULL,
  method = "aeks",
  n_iter = 1000,
  q.cut = 0.1,
  or.cut = 1.5,
  seed = NULL,
  verbose = FALSE
)
}
\arguments{
\item{df}{a data.frame with 3 columns. The function allows two data types. One type (data type I) consists data on the report level, including
ID, Drug type and AE name. The other type (data type II) consists of aggregated data, including
drug type, AE name and Count. Data should be ordered as
ID, Drug type, AE name in data type I and Drug type, AE name, Count in data type II.}

\item{dd.group}{a data.frame with AE name and Group
name. This data.frame have the group information for each individual AE.}

\item{drug.case}{a character string for the target drug of interest.}

\item{drug.control}{a character string for the reference drug. If NULL(default),
all other drugs combined are the reference.}

\item{method}{a character string specifying the method for the enrichment test.
It must take "aeks" (default) or "aefisher"; "aeks" is the rank-based
enrichment test, and "aefisher" is the modified Fisher enrichment test. See
details described in the paper (see reference section of this document).}

\item{n_iter}{an integer value specifying the number of iterations in aeks
method or the number of permutations in aefisher.}

\item{q.cut}{a numerical value specifying the significance cut for q value
of AEs in aefisher.}

\item{or.cut}{a numerical value specifying the significance cut for odds ratio
of AEs in aefisher.}

\item{seed}{a numeric seed for reproducible analysis.}

\item{verbose}{logical, if TRUE, print iterations. If FALSE, silence printing
to the console. Default is verbose = FALSE.}
}
\value{
A list containing 2 data.frames named \strong{Final_result} and \strong{AE_info}.

The \strong{Final_result} data.frame contains the following columns:
\itemize{
\item{GROUP_NAME: }{AE group names}
\item{ES: }{enrichment score}
\item{p_value: }{p value of the enrichment test}
\item{GROUP_SIZE: }{number of AEs per group}
}

The \strong{AE_info} in 'aeks' contains the following columns:
\itemize{
\item{AE_NAME: }{AE names}
\item{Ratio: }{reporting rate}
\item{p_value: }{p value for AE-drug association}
}

The \strong{AE_info} in 'aefisher' contains the following columns:
\itemize{
\item{AE_NAME: }{AE names}
\item{OR: }{Odds ratio for AE-drug association}
\item{p_value: }{p value for AE-drug association}
}
}
\description{
Adverse event (AE) enrichment analysis. Unlike the continuous gene expression data, AE
data are counts. Therefore, AE data has many zeros and ties. We propose two
enrichment tests. AEFisher is a modified Fisher's exact test based on pre-selected
significant AEs, while AEKS is based on a modified Kolmogorov-Smirnov
statistic.
}
\examples{

drug.case = 'FLUN'
drug.control = 'FLU'

# AEKS
## Input data using data Type I
KS_result1 = enrich(df = flu1, dd.group = group, drug.case = drug.case, 
                    drug.control = drug.control, method = 'aeks', n_iter = 10)
## Input data using data Type II
\donttest{
KS_result2 = enrich(df = flu2, dd.group = group, drug.case = drug.case, 
                    drug.control = drug.control, method = 'aeks', n_iter = 1000)

# AEFisher
fisher_result1 = enrich(df = flu1, dd.group = group, drug.case = drug.case, 
                        drug.control = drug.control, method = 'aefisher', 
                        n_iter = 1000, q.cut = 0.1, or.cut=1.5)
}
}
\references{
Li, S. and Zhao, L. (2020). Adverse event enrichment tests using
VAERS. \href{https://arxiv.org/abs/2007.02266}{arXiv:2007.02266}.
}
