% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AFMVariogramAnalyser.R
\name{calculateDirectionalVariograms}
\alias{calculateDirectionalVariograms}
\title{Calculate experimental directional semi-variograms}
\usage{
calculateDirectionalVariograms(AFMImageVariogramAnalysis, AFMImage)
}
\arguments{
\item{AFMImageVariogramAnalysis}{an \code{\link{AFMImageVariogramAnalysis}} to manage and store the result of variogram analysis}

\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}
}
\value{
Four directional variograms
}
\description{
calculate four experimental directional variograms of an \code{\link{AFMImage}} with the \code{\link[gstat]{variogram}} function of the gstat package.
The directional semi-variogram can be used to check the isotropy of the sample.
Note: The sample will be isotropic if the slopes of the four variograms are similar.
}
\details{
\code{calculateDirectionalVariograms} returns the directional variograms
}
\examples{
\dontrun{
library(AFM)
library(ggplot2)

data(AFMImageOfRegularPeaks)
variogramAnalysis<-AFMImageVariogramAnalysis(sampleFitPercentage=3.43)
varios<-AFM::calculateDirectionalVariograms(AFMImage= AFMImageOfRegularPeaks,
                                            AFMImageVariogramAnalysis= variogramAnalysis)
dist<-gamma<-NULL
p <- ggplot(varios, aes(x=dist, y=gamma,
                        color= as.factor(dir.hor),
                        shape=as.factor(dir.hor)))
p <- p + expand_limits(y = 0)
p <- p + geom_point()
p <- p + geom_line()
p <- p + ylab("semivariance (nm^2)")
p <- p + xlab("distance (nm)")
p <- p + ggtitle("Directional")
p
}
}
\author{
M.Beauvais
}

