% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AFMVariogramAnalyser.R
\name{getAutomaticWidthForVariogramCalculation}
\alias{getAutomaticWidthForVariogramCalculation}
\title{calculate a width to be used for experimental variogram calculation}
\usage{
getAutomaticWidthForVariogramCalculation(AFMImage)
}
\arguments{
\item{AFMImage}{an \code{\link{AFMImage}} from Atomic Force Microscopy}
}
\value{
the smallest width to be used for variogram calculation
}
\description{
calculate a width to be used for experimental variogram calculation in order to generate a line
instead of a cloud of points. If the chosen width is too small, the experimental variogram will
be a cloud of points instead of a line.
}
\details{
\code{getAutomaticWidthForVariogramCalculation} returns the width to be used for variogram calculation
}
\examples{
library(AFM)

data(AFMImageOfAluminiumInterface)
print(getAutomaticWidthForVariogramCalculation(AFMImageOfAluminiumInterface))
}
\author{
M.Beauvais
}

